/**
 * <p>
 * Title: UException.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 * @author matt @date 2020年9月28日 @version 1.0
 */
package com.northpool.exception;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @author matt
 *
 */
public class    UException {

    static Logger logger = LoggerFactory.getLogger(UException.class);

    public static <E extends Throwable> void printStackTrace(E e) {
        if (logger.isInfoEnabled()) {
            e.printStackTrace();
        }
    }

    public static String toJSON(Throwable e) {
        return ExceptionToJSON.toJSON(e);
    }

    public static <E extends Throwable> String toJSONArray(List<E> errors) {
        return ExceptionToJSON.toJSONArray(errors);
    }

    public static <E extends Throwable> List<E> fromJSONArrAy(String exceptionArrStr) {
        return ExceptionToJSON.fromJSONArrAy(exceptionArrStr);
    }

    public static <E extends Throwable> E fromJSON(String exceptionStr) {
        return ExceptionToJSON.fromJSON(exceptionStr);
    }
    
    public static <E extends Throwable> String toString(List<E> errors){
        List<String> errorArrayStr = new ArrayList<>();
        for(E e : errors){
            errorArrayStr.add(toString(e));
        }
        return "\n         " + String.join("\n        ", errorArrayStr);
     //   return null;
    }

    public static <E extends Throwable> String toString(E e){
        return e.getStackTrace()[0].toString() + ":" + e.getMessage();
    }
 
}
