package com.northpool.pixel.resmple;

import java.nio.ByteBuffer;


public class NearestNeighbour implements Fn1DResamplingFunction{

	public static final NearestNeighbour INSTANCE = new NearestNeighbour();
	
	@Override
	public void resampling(ByteBuffer dstBuffer, int dstInitialOffset, int numDstPixels, int dstPixelStride,
			ByteBuffer srcBuffer, int srcInitialOffset, int numSrcPixels, int srcPixelStride, int numBytesPerPixel) {
		// TODO Auto-generated method stub
		int accumulator = 0;

	    for (int dstPixelIndex = 0; dstPixelIndex < numDstPixels; dstPixelIndex++) {
	        int srcPixelIndex = (int)(accumulator / numDstPixels) * srcPixelStride + srcInitialOffset;	// We need a truncating integer division operator.
	   
	        switch (numBytesPerPixel) {
	            case 4:
                    dstBuffer.put(dstInitialOffset + 3,srcBuffer.get(srcPixelIndex + 3));

	               // dstBuffer[dstInitialOffset + 3] = srcBuffer[srcPixelIndex + 3];
	            case 3:			// eslint-disable-line
	            	dstBuffer.put(dstInitialOffset + 2,srcBuffer.get(srcPixelIndex + 2));
	            	dstBuffer.put(dstInitialOffset + 1,srcBuffer.get(srcPixelIndex + 1));
	            	
	           //     dstBuffer[dstInitialOffset + 2] = srcBuffer[srcPixelIndex + 2];
	           //     dstBuffer[dstInitialOffset + 1] = srcBuffer[srcPixelIndex + 1];
	            case 1:			// eslint-disable-line
	            	dstBuffer.put(dstInitialOffset,srcBuffer.get(srcPixelIndex));
	            //    dstBuffer[dstInitialOffset] = srcBuffer[srcPixelIndex];
	            default:		// eslint-disable-line
	                break;
	        }

	        dstInitialOffset += dstPixelStride;
	        accumulator += numSrcPixels;
	    }
	}

	
	
}
