package com.northpool.spatial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.northpool.spatial.grid.Constants.GRID_UNIT;

/**
 * 
 * @author matt
 *
 */
public class Constants {
	
	
	public static enum GEO_TYPE{
		UNKNOWN,POINT,LINESTRING,POLYGON,MULTIPOINT,MULTILINESTRING,MULTIPOLYGON,COLLECTION,GEOMETRY
	}
	
	
	/*public static GEO_TYPE D3toD2(GEO_TYPE type){
	    
	}*/
	
	public static enum SPATIAL_UNIT{
		degree, meter
	}
	
	public enum SPATIAL_TYPE {
        sdo,hexwkb,sde,shape,wkb,wkt,jtsGeometry,esriGeometry,gdalGeometry,geoBuffer;
    }
	
	
	public static final List<String> GEO_TYPE_ARR ;
	static {
		List<String> i = new ArrayList<String>();
		GEO_TYPE[] values = GEO_TYPE.values();
		for(GEO_TYPE type : values){
			i.add(type.name());
		}
		GEO_TYPE_ARR = Collections.unmodifiableList(i);
	}
	
	public static SPATIAL_UNIT getSpatialUnitBySRID(Integer srid){
		if(srid == 3857 || srid == 900913){
			return SPATIAL_UNIT.meter;
		}else{
			return SPATIAL_UNIT.degree;
		}
		
	}
	
	public static enum LAYER_TYPE {
	    RASTER, VECTOR;
	}
	
	public static GRID_UNIT getGridUnitBySrid(Integer srid) {
	    switch (srid) {
        case 4214:
        case 4326:
        case 4490:
        case 4610:
            return GRID_UNIT.degree;
        case 3857:
        case 900913:
            return GRID_UNIT.meter;
        default:
            return GRID_UNIT.meter;
        }
	}
	
}