/**
　 * <p>Title: Builder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年3月29日
　 * @version 1.0
*/
package com.northpool.spatial;

import com.northpool.spatial.Constants.GEO_TYPE;

/**
 * @author matt
 *
 */
public interface GeomBuilder<E> {
    public E newInstance(GEO_TYPE geoType,int srid ,int dimension);

    /**
     * @param x
     * @param to
     */
    public void setX(double x, E e);

    /**
     * @param y
     * @param to
     */
    public void setY(double y, E e);

    /**
     * @param z
     * @param to
     */
    public void setZ(double z, E e);

    /**
     * @param nParts
     */
    public void setPolygonPartSize(int nParts);

    /**
     * @param nParts
     */
    public void setMultiPartSize(int nParts);

    /**
     * @param count
     */
    public void setPartCoordinatesSize(int count);

 
    
    
    
}
