package com.northpool.spatial.grid;

import com.northpool.commons.util.PackageUtil;
import com.northpool.spatial.grid.Constants.GRID_BASE;
import com.northpool.spatial.grid.Constants.GRID_TYPE;
import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.impl.GridName;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Set;

public class GridManager {


	private static HashMap<String,QuadtreeGrid> QUADTREE_MAP;

	private static String SCAN_PACKAGE =  "com.northpool.spatial.grid.impl.quadtreegrid";

	static{
		QUADTREE_MAP = new HashMap<String,QuadtreeGrid>();
		Set<Class<?>> gridClassSet = null;
		try {
			gridClassSet = PackageUtil.findClassAnnotation(SCAN_PACKAGE, GridName.class);
		} catch (ClassNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		gridClassSet.forEach(gridClass ->{

			try {

				GridName gridName = (GridName) gridClass.getAnnotation(GridName.class);
				String name = gridName.name();
				QuadtreeGrid grid = (QuadtreeGrid) gridClass.newInstance();
				QUADTREE_MAP.put(name, grid);
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		});
	}

	/**
	 * 返回二叉树格网
	 * @param unit 格网单位
	 * @param base 格网大小
	 * @param type 格网类型
	 * @return
	 */
	public static QuadtreeGrid getQuadtreeGrid(GRID_UNIT unit, GRID_BASE base, GRID_TYPE type){
		String gridBeanName = type.name() + "_" + unit.name() + "_" + base.name();
		QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
		if(grid == null){
			throw new RuntimeException("没有找到格网为" + gridBeanName);
		}
		return grid;
	}

	public static QuadtreeGrid getQuadtreeGrid(GRID_UNIT unit, GRID_BASE base, GRID_TYPE type, int[] origin, double[] resolutions){
		String gridBeanName = type.name() + "_" + unit.name() + "_" + base.name();
		if (origin != null && resolutions != null){
			QuadtreeGrid grid = GridManager.getQuadtreeGrid(gridBeanName, origin, resolutions);
			return grid;
		}
		QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
		if(grid == null){
			throw new RuntimeException("没有找到格网为" + gridBeanName);
		}
		return grid;
	}


	public static QuadtreeGrid getQuadtreeGrid(String gridBeanName){

		QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
		if(grid == null){
			throw new RuntimeException("没有找到格网为" + gridBeanName);
		}
		return grid;
	}

	public static QuadtreeGrid getQuadtreeGrid(String gridBeanName, int[] origin, double[] resolutions){
		if (origin == null && resolutions == null){
			return getQuadtreeGrid(gridBeanName);
		}

		int minX = origin[0];
		int maxY = origin[1];
		String key = GridManager.getGridKey(gridBeanName, origin, resolutions);
		QuadtreeGrid grid = null;
		grid = QUADTREE_MAP.get(key);
		if(grid == null){
			grid = QUADTREE_MAP.get(gridBeanName);
			if (grid == null){
				throw new RuntimeException("没有找到格网为" + gridBeanName);
			}
			try {
				grid = (QuadtreeGrid) grid.getClass().newInstance();
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}

			grid.setResolutions(resolutions);
			grid.setMinX(minX);
			grid.setMaxY(maxY);
			synchronized (QUADTREE_MAP){
				QUADTREE_MAP.put(key, grid);
			}
		}
		return grid;
	}

	public static String getGridKey(String gridBeanName, int[] origin, double[] resolutions) {
		int minX = origin[0];
		int maxY = origin[1];
		StringBuilder keyBuilder = new StringBuilder(gridBeanName);
		keyBuilder.append("_");
		keyBuilder.append(minX);
		keyBuilder.append("_");
		keyBuilder.append(maxY);
		keyBuilder.append("_");
		keyBuilder.append(StringUtils.join(resolutions, ","));
		String key = keyBuilder.toString();
		return key;
	}

	public static void main(String[] aaa){
		
		
		
		
		
		
		QuadtreeGrid grid = GridManager.getQuadtreeGrid(GRID_UNIT.degree,GRID_BASE.base512,GRID_TYPE.esri);

		System.out.print(grid.getExtent(3, 3, 0).getWkt());
	}
}