package com.northpool.spatial.grid;

import com.northpool.spatial.tool.SimpleGISTool;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.DoubleBuffer;
import java.util.*;
import java.util.concurrent.ExecutorService;


/**
 * 计算1\2\3\4\5\6-10\11-15\16-20级的网格
 * @author matt
 *
 */
public class ScanLine {

	Logger logger = LoggerFactory.getLogger(ScanLine.class);

	private ExecutorService executor;
	
	private Integer[] levels;
	
	
	private static int INT_EMTPY = -999999999;
	
	
	private HashMap<Integer,Set<String>> holder = new HashMap<Integer,Set<String>>();

	public HashMap<Integer, Set<String>> getExtents() {
		return holder;
	}
	

	private ArrayList<double[][]> features = new ArrayList<double[][]>();
	
	private Grid grid;
		
	public ScanLine(Integer threads,Integer[] levels,Grid grid){
		//this.executor = Executors.newFixedThreadPool(threads);
		this.grid = grid;
		this.levels = levels;
		this.createHashMap();
	}
	

	
	
	private void createHashMap(){
		for(int i = 0 ; i < this.levels.length ; i ++){
			
			HashSet<String> set = new HashSet<String>();
			holder.put(this.levels[i], set);
		}
	}
	
	public void close(){
		//this.executor.shutdown();
	}
	
/*	public void addGeoBuffer(GeoBuffer feature){
		this.features.add(feature);
	}*/
	
	public void calculate(double[][] points){
		for(int i = 0 ; i < this.levels.length ; i ++){
			Set s = this.calculateForEachLevel(points,levels[i]);
			holder.put(levels[i], s);
		}
	}
	
	
	private Set calculateForEachLevel(double[][] points,Integer level){
		
		return this.polyRingCover(points, level);
		
		//ConcurrentSkipListSet<Long> set = this.holder.get(level);
		
		
		/*final CompletableFuture<Object[]>[] promiseArr = features.stream().map(geoBuffer -> {
			CompletableFuture<Object[]> promise = this.calculateForGeoFeaturePromise(geoBuffer, level, set);
			return promise;
		}).toArray(CompletableFuture[]::new);
		
		CompletableFuture.allOf(promiseArr).join();*/
		
	}
	
	
	
	
	
	
	
	private Set<String> polyRingCover(double[][] points,int level){
		//首先先简化
		
		double[][] newPoly = this.simplify(points, level);
		//找最大最小的Y
		
		double resolution = this.grid.getResolution(level);
		double minY = INT_EMTPY;
		double maxY = INT_EMTPY;
		
		for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
			double[] subPoints = newPoly[pathIndex];
	        for(int i = 0 ; i < subPoints.length/2 ; i ++){
	        	double y = subPoints[i * 2 + 1];
	        	if(minY == INT_EMTPY){
	        		minY = y;
	        	}
	        	if(maxY == INT_EMTPY){
	        		maxY = y;
	        	}
	        	if(y >= maxY){
	        		maxY = y;
	        	}
	        	if(y < minY){
	        		minY = y;
	        	}
	        }
	    }
		
		double scanlineY = minY;
		double gridExtendMaxY = maxY;
		
		double minX = 0;
		double maxX = (int)((this.grid.getMaxX() - this.grid.getMinX()) / resolution);
		HashSet scanXY = new HashSet();
		
		//开始扫描
		while(scanlineY <= gridExtendMaxY){
			//创建扫描线
			long a1 = System.currentTimeMillis();
			double[][] scanline = null;
			scanline = new double[][]{new double[]{minX,scanlineY},new double[]{maxX,scanlineY}};	
			int Y = (int)(scanlineY/ this.grid.getBase());
	
			ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
			for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
				double[] subPoints = newPoly[pathIndex];
				if(subPoints.length <= 2){
					//只有一个点的情况
					double x = (int)(subPoints[0] / this.grid.getBase());
					double y = (int)(subPoints[1]);
					if(y == scanlineY){
						scanlineXDoubleArray.add(x);
					}
				}else{
					//是线段面的情况
				     double tmpY;  
					 for(int i = 0 ; i < subPoints.length/2 - 1 ; i ++){
						double point1x = subPoints[i * 2];
						double point1y = subPoints[i * 2 + 1];
						double point2x = subPoints[i * 2 + 2];
						double point2y = subPoints[i * 2 + 3];
						// 查看该线段是否有可能与扫描线相交;
						if (point1y < scanlineY && point2y < scanlineY) {
							continue;
						}

						if (point1y > scanlineY && point2y > scanlineY) {
							continue;
						}
						//如果对比线段的第二个点在扫描线上
						
						if(point2y == scanlineY){
						    //记录下第一个点的Y到临时TMPY中
						    tmpY = point1y;
						    double x = (int)(point2x / this.grid.getBase());
						    //加入X坐标
						    scanlineXDoubleArray.add(x);
						    
						    while(true){
						        //取下一条线
						        i = i + 1;
						        if(i == subPoints.length/2 - 1){
						            break;
						        }
						        double pointNext1x = subPoints[i * 2];
		                        double pointNext1y = subPoints[i * 2 + 1];
		                        double pointNext2x = 0.000d;
		                        try{
		                            pointNext2x = subPoints[i * 2 + 2];
		                        }catch(Exception e){
		                            this.logger.warn("扫描线异常",e);
		                        }
		                        double pointNext2y = subPoints[i * 2 + 3];
		                        //如果是正好在扫描线上,则跳过这条线
		                        if(pointNext1y == pointNext2y && pointNext2y == scanlineY){
		                            continue;
		                        }else{
		                            //检查与临时tmpY在同侧还是与tmpY在异侧
		                            boolean tmpYSide = scanlineY - tmpY > 0 ? true : false;
		                            boolean nextSide = scanlineY - pointNext2y > 0 ? true : false;
		                            if(tmpYSide == nextSide){
		                                
		                                double xNext = (int)(pointNext2x / this.grid.getBase());
		                                scanlineXDoubleArray.add(xNext);
		                            }
		                            break;
		                        }
						    }
						    
						}else{
						
						

    						double[] intersection = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0],
    								scanline[1][1], point1x, point1y, point2x, point2y);
    						if (intersection != null) {
    							double x = (int)(intersection[0] / this.grid.getBase());
    							double y = (int)(intersection[1] / this.grid.getBase());
    							scanlineXDoubleArray.add(x);
    						}
						}
				        	
			        }
					//最后一个点
			        double point1x = subPoints[subPoints.length - 2];
		        	double point1y = subPoints[subPoints.length - 1];
		        	double point2x = subPoints[0];
		        	double point2y = subPoints[1];
		        	if (point1y < scanlineY && point2y < scanlineY) {
						continue;
					}
					if (point1y > scanlineY && point2y > scanlineY) {
						continue;
					}
		        	double[] intersection = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], 
		        			point1x, point1y,point2x, point2y);
		        	if(intersection != null) {
		        		double x = (int)(intersection[0] / this.grid.getBase());
						double y = (int)(intersection[1] / this.grid.getBase());
						scanlineXDoubleArray.add(x);
		            }	        	
				}
			}
			
			/*for(int i = 0 ; i < scanlineXDoubleArray.size() ; i ++){
				int x = (int)(scanlineXDoubleArray.get(i)/1);
				
				//Integer[] extentint = new Integer[]{x,(int)(scanlineY/ this.getBase())};
				StringBuilder key = new StringBuilder().append(x).append("_").append((int)(scanlineY/ this.getBase()));
            	scanXY.add(key.toString());
			}*/

			
			Collections.sort(scanlineXDoubleArray, new Comparator<Double>() {
			    @Override
    			public int compare(Double o1, Double o2) {
    			    
    				return o1.compareTo(o2);
    			}
    		});
			
			for(int intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size(); intersectionsIndex++) {
	            if(intersectionsIndex % 2 == 0){
	            	double intersectionXEnter = scanlineXDoubleArray.get(intersectionsIndex );
	            	//double intersectionXExit = scanlineXDoubleArray.get(intersectionsIndex + 1);
	            	double intersectionXExit = intersectionXEnter;
					if (intersectionsIndex < scanlineXDoubleArray.size() - 1){
						intersectionXExit = scanlineXDoubleArray.get(intersectionsIndex + 1);
					}
	            	int enterX = (int)intersectionXEnter ;
	            	int exitX = (int)intersectionXExit ;
	            	
	               // int x = enter.getX();	            	
	            	while (enterX <= exitX) {
	                	//Integer[] extentint = new Integer[]{enterX,(int)(scanlineY/ this.getBase())};
	                	//String key = enterX + "_" + (int)(scanlineY/ this.getBase());
	                	//scanXY.put(key, extentint);
	            		//Long l = twoInt2Long(enterX,Y);
	            		String key = enterX + "_" + Y;
	                	//StringBuilder key = new StringBuilder().append(enterX).append("_").append((int)(scanlineY/ this.getBase()));
	                	scanXY.add(key);
	                	//scanXY.add(key.toString());
	                	enterX ++;
	                }
	            }
	        }
			
			scanlineY = scanlineY + 1;

		}
		
		return  scanXY;
		
	}
	
	
	
	
	
	
	
	
//	private void polyRingCover(ArrayList<DoubleBuilder> points,int level,ConcurrentSkipListSet<Long> set){
//		//首先先简化
//		double resolution = this.grid.getResolution(level);
//		
//		DoubleBuilder[] newPoly = this.simplify(points, level);
//		//找最大最小的Y
//		double minY = INT_EMTPY;
//		double maxY = INT_EMTPY;
//		
//		for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
//			DoubleBuilder subPoints = newPoly[pathIndex];
//			int i = 0;
//			while (i < subPoints.size()) {
//				double y = subPoints.get(i + 1);
//	        	if(minY == INT_EMTPY){
//	        		minY = y;
//	        	}
//	        	if(maxY == INT_EMTPY){
//	        		maxY = y;
//	        	}
//	        	if(y >= maxY){
//	        		maxY = y;
//	        	}
//	        	if(y < minY){
//	        		minY = y;
//	        	}
//	        	i += 2;
//	        }
//	    }
//		
//		double scanlineY = minY;
//		double gridExtendMaxY = maxY;
//		
//		double minX = 0;
//		double maxX = (int)((this.grid.getMaxX() - this.grid.getMinX()) / resolution);
//		
//		while(scanlineY <= gridExtendMaxY){
//			//创建扫描线
//			double[][] scanline = null;
//			scanline = new double[][]{new double[]{minX,scanlineY},new double[]{maxX,scanlineY}};	
//			int Y = (int)(scanlineY/ this.grid.getBase());
//			ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
//			
//			for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
//				DoubleBuilder subPoints = newPoly[pathIndex];
//				if(subPoints.size() <= 2){
//					//只有一个点的情况
//					double y = (int)(subPoints.get(1));
//					if(y == scanlineY){
//						double x = (int)(subPoints.get(0) / this.grid.getBase());
//						scanlineXDoubleArray.add(x);
//					}
//				}else{
//					//是线段面的情况
//					int size = subPoints.size();
//					 for(int i = 0 ; i < size / 2 - 1 ; i ++){
//						double point1x = subPoints.get(i * 2);
//						double point1y = subPoints.get(i * 2 + 1);
//						double point2x = subPoints.get(i * 2 + 2);
//						double point2y = subPoints.get(i * 2 + 3);
//						// 查看该线段是否有可能与扫描线相交;
//						if (point1y < scanlineY && point2y < scanlineY) {
//							continue;
//						}
//						if (point1y > scanlineY && point2y > scanlineY) {
//							continue;
//						}
//
//						double[] intersection = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0],
//								scanline[1][1], point1x, point1y, point2x, point2y);
//						if (intersection != null) {
//							double x = (int)(intersection[0] / this.grid.getBase());
//							double y = (int)(intersection[1] / this.grid.getBase());
//							scanlineXDoubleArray.add(x);
//						}
//				        	
//			        }
//					//最后一个点
//			        double point1x = subPoints.get(size - 2);
//		        	double point1y = subPoints.get(size - 1);
//		        	double point2x = subPoints.get(0);
//		        	double point2y = subPoints.get(1);
//		        	if (point1y < scanlineY && point2y < scanlineY) {
//						continue;
//					}
//					if (point1y > scanlineY && point2y > scanlineY) {
//						continue;
//					}
//		        	double[] intersection = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], 
//		        			point1x, point1y,point2x, point2y);
//		        	if(intersection != null) {
//		        		double x = (int)(intersection[0] / this.grid.getBase());
//						double y = (int)(intersection[1] / this.grid.getBase());
//						scanlineXDoubleArray.add(x);
//		            }	        	
//				}
//				
//				Collections.sort(scanlineXDoubleArray, new Comparator<Double>() {
//	    			public int compare(Double x1, Double x2) {
//	    				
//	    				return x1.compareTo(x2);
//	    			}
//	    		});
//				
//				for(int intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size() - 1; intersectionsIndex++) {
//		            if(intersectionsIndex % 2 == 0){
//		            	double intersectionXEnter = scanlineXDoubleArray.get(intersectionsIndex );
//		            	double intersectionXExit = scanlineXDoubleArray.get(intersectionsIndex + 1);
//		            	
//		            	int enterX = (int)intersectionXEnter ;
//		            	int exitX = (int)intersectionXExit ;
//		            	while (enterX <= exitX) {
//		            		Long l = twoInt2Long(enterX,Y);
//		            	//	set.add(l);
//		                	enterX ++;
//		                }
//		            }
//		        }
//				scanlineY = scanlineY + 1;
//			}
//		}
//	}
	
	
	private static long twoInt2Long(int low,int high){  
		 return ((long)low & 0xFFFFFFFFL) | (((long)high << 32) & 0xFFFFFFFF00000000L);
	} 

	public static int[] long2Ints(long val){
		int[] ret = new int[2];
		ret[0] = (int) (0xFFFFFFFFL & val);
		ret[1] = (int) ((0xFFFFFFFF00000000L & val) >> 32);
        return ret;
	}
	
	private double[][] simplify(double[][] points,int level){
		double[][] newPoly = new double[points.length][];
		double resolution = this.grid.getResolution(level);
		for(int index = 0;  index < newPoly.length; index ++){
			double[] doubleArr = points[index];
			double[] parent = new double[]{-1d,-1d};
			DoubleBuffer buffer = DoubleBuffer.allocate(doubleArr.length);
			for(int i = 0 ; i < doubleArr.length /2 ; i ++){
				double x = doubleArr[i * 2];
				double y = doubleArr[i * 2 + 1];
				//this.calculateX(resolution, x)
				double _x = (int)((x - this.grid.getMinX()) / resolution) ; 
				double _y = (int)((this.grid.getMaxY() - y) / resolution) ;
				if(parent[0] == -1 && parent[1] == -1){
					//如果没有
					parent[0] = _x;
					parent[1] = _y;
					buffer.put(_x);
					buffer.put(_y);
				}else if(parent[0] == _x && parent[1] == _y){
					continue;
				}else{
					parent[0] = _x;
					parent[1] = _y;
					buffer.put(_x);
					buffer.put(_y);
				}
			}
			buffer.flip();
			
			double[] newCoordinates = new double[ buffer.limit()];
			//buffer.
			buffer.get(newCoordinates, 0, newCoordinates.length);
			
			newPoly[index] = newCoordinates;
		}
		return newPoly;
	}
	
	
	public static double[][] create(Geometry geom) throws Exception{
		
		
		int length = geom.getNumGeometries();
		double[][] darr = new double[length][];
		for(int i = 0 ; i < length ; i ++){
			
			Geometry sub = geom.getGeometryN(i);
			Coordinate[] cc = sub.getCoordinates();
			int cclength = cc.length;
			double[] subArr = new double[cclength * 2];
			
			for(int j = 0 ;j < cclength ; j ++){
				Coordinate c = sub.getCoordinates()[j];
				subArr[j*2] = c.x;
				subArr[j*2 + 1] = c.y;
			}
			darr[i] = subArr;
		}
		return darr;
	}
	
	
	
	

	
	
//	public static void main(String[] aaaa) throws Exception {
//	    WKTReader reader = new WKTReader();
//	    long a1 = System.currentTimeMillis();
//	       for(int i = 0 ; i < 1000000 ; i ++){   
//	           reader.read("MULTIPOLYGON(((114.31083332487 34.8856367950695,114.310574321403 34.8856116661628,114.310530083664 34.8859251057017,114.310720644989 34.8859803826414,114.311013182444 34.8860748647047,114.312500000372 34.8863199799135,114.312500000372 34.8859063233233,114.312055190305 34.8858321021269,114.311562208855 34.8857468929918,114.311140628323 34.8856797458767,114.31083332487 34.8856367950695)),((114.310752702287 34.8851725928822,114.310811422738 34.8851570894386,114.310830111586 34.8851586839397,114.310877324289 34.8851627138098,114.311278425419 34.882991729875,114.312325529749 34.883150164655,114.312500000372 34.8823533511433,114.312500004869 34.8787194542069,114.312025596255 34.8787100283937,114.312063932632 34.8785368078304,114.311690441643 34.8785431336743,114.311477661623 34.8785602073374,114.3109053733 34.8786823058371,114.310339275924 34.878822717268,114.309815135601 34.87887980005,114.309662307206 34.8788664298025,114.308898574422 34.8824642449671,114.309052526972 34.8824906778934,114.310234000176 34.8827575738264,114.311084232624 34.8829496352241,114.311081484291 34.8829619298803,114.311052359688 34.8830921852471,114.310848991092 34.884190453009,114.310667209865 34.8851721081467,114.310752702287 34.8851725928822)),((114.310028760087 34.8846069460666,114.30895771126 34.8844175592581,114.308868170981 34.8848621660782,114.309939225204 34.8850515537861,114.310028760087 34.8846069460666)))");
//	       }
//	       System.out.println(System.currentTimeMillis() - a1);//27065
//	    
	    
	    
//        String path = "C:\\Users\\matt\\Desktop\\polygon.txt";
//        String aaa = new String(FileUtil.File2byte(path));
//        String[] wktList = aaa.split("\n");
//        
//       // List<String> wktList = FileUtils.readLines(new File(path), "UTF-8");
//        double[][] points;
//        Set<Long> result = new HashSet<>();
//        Grid grid = GridManager.getQuadtreeGrid(GRID_UNIT.degree, GRID_BASE.base256, GRID_TYPE.tdt);
//
//        for (int i = 0; i < wktList.length; i++) {
//            String wkt = wktList[i];
//            Geometry geom;
//            try {
//                geom = new WKTReader().read(wkt);
//                points = create(geom);
//            } catch (Exception e) {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//                throw new RuntimeException(wkt + "不是标准的WKT");
//            }
//
//
//
//            ScanLine scanLine = new ScanLine(1,new Integer[]{9},grid);
//
//            long c1 = System.currentTimeMillis();
//
//
//            //POLYGON((105.18236967034125 26.379616885913585,105.5341427790352 26.379616885913585,105.5341427790352 26.259977654367216,105.18236967034125 26.259977654367216,105.18236967034125 26.379616885913585))
//
//            //  double[] points1 = new double[]{105.18236967034125, 26.379616885913585,105.5341427790352, 26.379616885913585,105.5341427790352, 26.259977654367216,105.18236967034125, 26.259977654367216,105.18236967034125, 26.379616885913585};
//
//            scanLine.calculate(points);
//          //  Set<Long> set = scanLine.getExtents().get(9);
//            result.addAll(set);
//        }
//
//        
//    //  System.out.println(System.currentTimeMillis() - c1);
//        
//
//        
//        System.out.println(result.size());
//        int i = 0;
//        for(Long a : result){
//           // System.out.println(long2Ints(a)[0]);
//           /// System.out.println(long2Ints(a)[1]);
//            i++;
//            System.out.println(grid.getExtent(9, long2Ints(a)[0], long2Ints(a)[1]).getWkt());
//            if(i == 500){
//                Thread.sleep(1000 * 10);
//            }
//        }
//        
//        
//        
//    //  System.out.println(grid.getExtent(11, 1623, 361).getWkt());
//        
    
   // }
    
	

}
