package com.northpool.spatial.grid.impl.quadtreegrid;

import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.impl.GridName;
import com.northpool.spatial.grid.impl.QuadtreeImpl;

@GridName(name = "esri_degree_base512")
public class EsriDegree512 extends QuadtreeImpl {

	double[] resolution;

	public EsriDegree512(){
		this.init(512, 2, GRID_UNIT.degree);
	}

	public EsriDegree512(int minX, int maxY, double[] resolution){
		this.init(512, 2, GRID_UNIT.degree);
	}

	protected void init(Integer base,int beginLevel, GRID_UNIT unit) {
		this.base = base;// 一张瓦片的大小（像素）
		this.unit = unit;
		this.minX = -400;
		this.minY = -90;
		this.maxX = 180;
		this.maxY = 400;
		this.beginLevel = beginLevel;



	}

	public Double getResolution(int level) {
		// 根据初始的分辨率计算层级上每个瓦片的分辨率
		if (level >= resolution.length || level < 0){
			return this.resolution[0] / Math.pow(2, level);
		}
		return this.resolution[level];//幂运算
	}


	@Override
	public void setResolutions(double[] resolution) {
		this.resolution = resolution;
	}

	@Override
	public double[] getResolutions(){
		return this.resolution;
	};
}