/**
　 * <p>Title: ShapeDecoder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月17日
　 * @version 1.0
*/
package com.northpool.spatial.shape;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;


import com.northpool.commons.util.BuilderCreator;
import com.northpool.commons.util.DoubleBuilder;
import com.northpool.commons.util.FileUtil;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.AGeomDecoder;
import com.northpool.spatial.GeomDecoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.geofeature.GeoPart;
import com.northpool.spatial.geofeature.GeoPart.RING_TYPE;

/**
 * @author matt
 *
 */

@AGeomDecoder(type = SPATIAL_TYPE.shape)
public class ShapeDecoder implements GeomDecoder<byte[]> {
    public static final ShapeDecoder DECODER = new ShapeDecoder();
    
  
    
    
    
    static public GEO_TYPE is(ShapeType type) {
        if(type.isPointType()){
            return GEO_TYPE.POINT;
        }
        if(type.isLineType()){
            return GEO_TYPE.MULTILINESTRING;
        }
        if(type.isPolygonType()){
            return GEO_TYPE.MULTIPOLYGON;
        }
        if(type.isMultiPointType()){
            return GEO_TYPE.MULTIPOINT;
        }
            
        throw new RuntimeException("未知的数据类型" + type.toString());
    }
    
    
    public GeoBuffer toGeoBuffer(byte[] bytes) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return toGeoBuffer(byteBuffer);
    }
    
    
    public GeoBuffer toGeoBuffer(ByteBuffer buffer) throws IOException {
        // TODO Auto-generated method stub
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        
        ShapeType recordType = ShapeType.forID(buffer.getInt());
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        if (recordType.isLineType() || recordType.isPolygonType()) {
            minX = buffer.getDouble();
            minY = buffer.getDouble();
            maxX = buffer.getDouble();
            maxY = buffer.getDouble();
        }
       /* if (recordType.isMultiPoint()) {
            minX = buffer.getDouble();
            minY = buffer.getDouble();
            maxX = buffer.getDouble();
            maxY = buffer.getDouble();
        } else if (recordType != ShapeType.NULL) {
            minX = maxX = buffer.getDouble();
            minY = maxY = buffer.getDouble();
        }*/
    
        GEO_TYPE geoType = is(recordType);
        
        int inputDimension =  recordType.isHasZ() ? 3 : 2;
        
        GeoBuffer geo = new GeoBuffer(geoType,0,inputDimension);
        
       
        
        geo = this.process(geoType, buffer, geo, recordType.isHasZ(), false);
        
        
        
        
        geo.setBBOX(minX, minY, maxX, maxY);
        
        return geo;
    }
    
    protected GeoBuffer process(GEO_TYPE geoType,ByteBuffer buffer,GeoBuffer geo,boolean hasZ,boolean hasM) throws IOException{
        switch (geoType) {
        case POINT:
            this.processPoint(buffer, geo,hasZ,hasM);
            
            break;
        /*case LINESTRING:

            this.processLineString(buffer, geo,hasZ);
            break;*/
        /*case POLYGON:
            this.processPolygon(buffer, geo,hasZ);
            break;*/
            
     //   case MULTIPOINT:
            //this.processMultiPoint(buffer, geo,hasZ);
       //     break;
        case MULTILINESTRING:
            this.processMultiLine(buffer, geo,hasZ,hasM);
            break;
        case MULTIPOLYGON:
            this.processMultiPolygon(buffer, geo,hasZ,hasM);
            break;
            
        case COLLECTION:
        default:
            throw new RuntimeException("不支持的几何类型：" + geoType.name());
            
        }
        geo.trimToSize();
        return geo;
    }

    
    
    
    
    
    
    


    private void processMultiPolygon(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        // TODO Auto-generated method stub
        int[] partOffsets;

        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        partOffsets = new int[numParts];

        for (int i = 0; i < numParts; i++) {
            partOffsets[i] = buffer.getInt();
        }
        
        int finish, start = 0;
        int length = 0;
        int dimension = hasZ == true ? 3 : 2;
        
        final DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        for (int part = 0; part < numParts; part++) {

            start = partOffsets[part];
            if (part == (numParts - 1)) {
                finish = numPoints;
            } else {
                finish = partOffsets[part + 1];
            }

            length = finish - start;

            double[] xy = new double[length * 2];
            
            doubleBuffer.get(xy);
            double minX = xy[0];
            double minY = xy[1];
            double maxX = xy[0];
            double maxY = xy[1];
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble((length + 1) * dimension);
            for (int i = 0; i < length; i++) {
                double x = xy[i * 2];
                double y = xy[i * 2 + 1];
                if(x > maxX){
                    maxX = x;
                }
                if(x < minX){
                    minX = x;
                }
                if(y > maxY){
                    maxY = y;
                }
                if(y < minY){
                    minY = y;
                }
                doubleBuilder.append(x);
                doubleBuilder.append(y);
                if(hasZ){
                    doubleBuilder.append(0.0d);
                }
            }
            if(dimension == 2){
            //看是否是close
                boolean isclose = false;
                if(doubleBuilder.get(0) == doubleBuilder.get((length - 1) * dimension) && doubleBuilder.get(1) == doubleBuilder.get(((length - 1) * dimension) + 1)){
                    isclose = true;
                }
                if(!isclose){
                    doubleBuilder.append(doubleBuilder.get(0));
                    doubleBuilder.append(doubleBuilder.get(1));
                }
            }
            
            
            RING_TYPE ringType = this.getRingType(doubleBuilder,dimension);
            geo.addPolygonPart(doubleBuilder, minX, minY, maxX, maxY, ringType);
        }   
        if (hasZ) {
            // z min, max
            // buffer.position(buffer.position() + 2 * 8);
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (int part = 0; part < numParts; part++) {
                start = partOffsets[part];
                DoubleBuilder doubleBuilder =  geo.getData(part);
                double minZ = Double.NaN;
                double maxZ = Double.NaN;
                GeoPart geoPart = geo.getPart(part);
                if (part == (numParts - 1)) {
                    finish = numPoints;
                } else {
                    finish = partOffsets[part + 1];
                }
                length = finish - start;
                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; i++) {
                    double value = z[i];
                    doubleBuilder.set(i * 3 + 2, value);
                    if(minZ == Double.NaN){
                        minZ = maxZ = value;
                    }else{
                        if(value < minZ){
                            minZ = value;
                        }
                        if(value > maxZ){
                            maxZ = value;
                        }
                    }
                }
                geoPart.setZInterval(minZ, maxZ);
                boolean isclose = false;
                if(doubleBuilder.get(0) == doubleBuilder.get((length - 1) * dimension) && doubleBuilder.get(1) == doubleBuilder.get(((length - 1) * dimension) + 1) && doubleBuilder.get(2) == doubleBuilder.get(((length - 1) * dimension) + 2) ){
                    isclose = true;
                }
                if(!isclose){
                    doubleBuilder.append(doubleBuilder.get(0));
                    doubleBuilder.append(doubleBuilder.get(1));
                    doubleBuilder.append(doubleBuilder.get(2));
                }
            }
        } 
        geo.tryMultiToSingle();
    }
    
    
    protected RING_TYPE getRingType(DoubleBuilder doubleBuilder,int dimension){

        if(GeoBuffer.isCCW(doubleBuilder, dimension)){
            return RING_TYPE.inside;
        }else{
            return RING_TYPE.outside;
        }
        
        
        /*int size = doubleBuilder.size();
        double d = 0;
        for (int i = 0; i < size - inputDimension; i = i + inputDimension) {
            d += 0.5 * (doubleBuilder.get(i + 1 + inputDimension) + doubleBuilder.get(i + 1)) * (doubleBuilder.get(i + inputDimension) - doubleBuilder.get(i));
        }
        if (d > 0) {// 面积大于0为顺时针
            return RING_TYPE.inside;
        } else {// 小于0为逆时针
            return RING_TYPE.outside;
        }*/
    }



    private void processMultiLine(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        // TODO Auto-generated method stub
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        
        int[] partOffsets = new int[numParts];

        // points = new Coordinate[numPoints];
        for (int i = 0; i < numParts; i++) {
            partOffsets[i] = buffer.getInt();
        }
        int finish, start = 0;
        int length = 0;
        boolean clonePoint = false;
        final DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
        int dimension = hasZ == true ? 3 : 2;
        for (int part = 0; part < numParts; part++) {
        
            
            
            start = partOffsets[part];
            if (part == (numParts - 1)) {
                finish = numPoints;
            } else {
                finish = partOffsets[part + 1];
            }

            length = finish - start;
            int xyLength = length;
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }

            double[] xy = new double[xyLength * 2];
            doubleBuffer.get(xy);
            double minX = xy[0];
            double minY = xy[1];
            double maxX = xy[0];
            double maxY = xy[1];
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble((xyLength + 1) * dimension);
            for (int i = 0; i < xyLength; i++) {
                double x = xy[i * 2];
                double y = xy[i * 2 + 1];
                if(x > maxX){
                    maxX = x;
                }
                if(x < minX){
                    minX = x;
                }
                if(y > maxY){
                    maxY = y;
                }
                if(y < minY){
                    minY = y;
                }
                doubleBuilder.append(x);
                doubleBuilder.append(y);
                if(hasZ){
                    doubleBuilder.append(0.0d);
                }
            }

            if (clonePoint) {
                doubleBuilder.append(doubleBuilder.get(0));
                doubleBuilder.append(doubleBuilder.get(1));
                if(hasZ){
                    doubleBuilder.append(0.0d);
                }
            }

            geo.addLinePart(doubleBuilder, minX, minY, maxX, maxY);
        }

       
        if (hasZ) {
            // z min, max
            // buffer.position(buffer.position() + 2 * 8);
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (int part = 0; part < numParts; part++) {
                start = partOffsets[part];
                double minZ = Double.NaN;
                double maxZ = Double.NaN;
                GeoPart geoPart = geo.getPart(part);
                DoubleBuilder doubleBuilder =  geo.getData(part);
                if (part == (numParts - 1)) {
                    finish = numPoints;
                } else {
                    finish = partOffsets[part + 1];
                }

                length = finish - start;
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }

                double[] z = new double[length];
                doubleBuffer.get(z);
                for (int i = 0; i < length; i++) {
                    double value = z[i];
                    doubleBuilder.set(i * 3 + 2, value);
                    if(minZ == Double.NaN){
                        minZ = maxZ = value;
                    }else{
                        if(value < minZ){
                            minZ = value;
                        }
                        if(value > maxZ){
                            maxZ = value;
                        }
                    }
                   
                }
                geoPart.setZInterval(minZ, maxZ);
                
            }
        }   
        geo.tryMultiToSingle();
    }


    private void processPoint(ByteBuffer buffer, GeoBuffer geo, boolean hasZ, boolean hasM) {
        // TODO Auto-generated method stub
        int dimension = hasZ == true ? 3 : 2;

        // 解析几何结构
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;

        
        if(hasZ){
            z = buffer.getDouble();
        }
        if(hasM){
            buffer.getDouble();
        }
        
        geo.addPoint(x,y,z);
    }
    
    public static void main(String[] aaa) throws IOException{
        byte[] aaaa = FileUtil.File2byte("c://tmp//shape");
        
        //Geometry  geometry = GeometryEngine.geometryFromEsriShape(aaaa, Type.Unknown);
        
        //byte[] ccc = GeometryEngine.geometryToEsriShape(geometry);
        
        //FileUtil.byte2File(ccc, "c://tmp//shape1");
        
        ByteBuffer b = ByteBuffer.wrap(aaaa);
        
        GeoBuffer buffer = ShapeDecoder.DECODER.toGeoBuffer(b);
        
        ShapeEncoder shapeEncoder = new ShapeEncoder();
        
        byte[] bytes1 = shapeEncoder.fromGeoBuffer(buffer);
        
      /*  int len = bytes.limit() - bytes.position();
        byte[] bytes1 = new byte[len];
        bytes.get(bytes1);*/
        
        
        ByteBuffer bb = ByteBuffer.wrap(bytes1);
        
        GeoBuffer buffer1 = ShapeDecoder.DECODER.toGeoBuffer(bb);
      //  System.out.println(buffer.toGeometry().toString());
        
     //   Geometry  geometry =  GeometryEngine.geometryFromWkt(buffer.toGeometry().toString(), 0, Type.Unknown);
        
    //    System.out.println(GeometryEngine.geometryToWkt(geometry, WktExportFlags.wktExportPolygon));
        
        FileUtil.byte2File(bytes1, "c://tmp//shape1");
        
        
       // org.locationtech.jts.io.WKBWriter
    }
}
