

package com.northpool.spatial.tool;


import com.northpool.commons.util.BuilderCreator;
import com.northpool.commons.util.DoubleBuilder;

public class Simplify {
	static double getSqDist(double p1X,double p1Y,double p2X, double p2Y) {

		double dx = p1X - p2X;
		double dy = p1Y - p2Y;

        return dx * dx + dy * dy;
    }
	
	
	/*static double getSqSegDist(double pX, double pY, double p1X, double p1Y, double p2X, double p2Y) {

		double x = p1X;
		double y = p1Y;
		double dx = p2X - x;
		double dy = p2Y - y;

		if (dx != 0d || dy != 0d) {

			double t = ((pX - x) * dx + (pY - y) * dy) / (dx * dx + dy * dy);

			if (t > 1d) {
				x = p2X;
				y = p2Y;

			} else if (t > 0) {
				x += dx * t;
				y += dy * t;
			}
		}

		dx = pX - x;
		dy = pY - y;

		return dx * dx + dy * dy;
	}*/
	
	public static DoubleBuilder simplifyRadialDist(DoubleBuilder  points, double sqTolerance) {
		DoubleBuilder newPoints = BuilderCreator.createDouble();
		double prevPointX = points.get(0);
		double prevPointY = points.get(1);
		newPoints.append(prevPointX).append(prevPointY);
		double pointX = -99999d;
		double pointY = -99999d;
		int len = points.size() / 2;
	    for (int i = 1 ; i < len; i++) {
	        pointX = points.get(i * 2);
	        pointY = points.get(i * 2 + 1);

	        if (getSqDist(pointX,pointY, prevPointX,prevPointY) > sqTolerance) {
	        	newPoints.append(pointX);
                newPoints.append(pointY);
                prevPointX = pointX;
                prevPointY = pointY;
            }else{
            	double nextX = -99999d;
        		double nextY = -99999d;
            	if(i != len - 1){
            		nextX = points.get(i * 2 + 2);
            		nextY = points.get(i * 2 + 3);
            	}else{
            		nextX = points.get(0);
            		nextY = points.get(1);
            	}
            	
            	if (getSqDist(pointX,pointY, nextX,nextY) > sqTolerance) {
        			newPoints.append(pointX);
                    newPoints.append(pointY);
                    prevPointX = pointX;
                    prevPointY = pointY;
        		}
    	        
            }
        }

        if (prevPointX != pointX && prevPointY != pointY && (pointX != -99999d || pointY != -99999d)) {
            newPoints.append(pointX);
            newPoints.append(pointY);
        }

        return newPoints;
    }
	
	/*static double getSquareSegmentDistance(double pX,double pY, double p1X,double p1Y,double p2X,double p2Y) {
		double x = p1X, y = p1Y;

		double dx = p2X - x, dy = p2Y - y;

		double t;

		if (dx != 0 || dy != 0) {
			t = ((pX - x) * dx + (pY - y) * dy)
					/ (dx * dx + dy * dy);

			if (t > 1) {
				x = p2X;
				y = p2Y;
				

			} else if (t > 0) {
				x += dx * t;
				y += dy * t;
				
			}
		}

		dx = pX - x;
		dy = pY - y;
		

		return dx * dx + dy * dy;
	}*/
	
	
	/*public static DoubleBuilder simplifyDouglasPeucker(DoubleBuilder points,double sqTolerance) {
		int len = points.size();

		Integer[] markers = new Integer[len];

		Integer first = 0;
		Integer last = len - 1;

		float maxSqDist;
		float sqDist;
		int index = 0;

		ArrayList<Integer> firstStack = new ArrayList<Integer>();
		ArrayList<Integer> lastStack = new ArrayList<Integer>();

		ArrayList<double[]> newPoints = new ArrayList<double[]>();

		markers[first] = markers[last] = 1;
 
		while (last != null) {
			maxSqDist = 0;

			for (int i = first + 1; i < last; i++) {
				sqDist = getSquareSegmentDistance(points[i], points[first],
						points[last]);

				if (sqDist > maxSqDist) {
					index = i;
					maxSqDist = sqDist;
				}
			}

			if (maxSqDist > sqTolerance) {
				markers[index] = 1;

				firstStack.add(first);
				lastStack.add(index);

				firstStack.add(index);
				lastStack.add(last);
			}

			if (firstStack.size() > 1)
				first = firstStack.remove(firstStack.size() - 1);
			else
				first = null;

			if (lastStack.size() > 1)
				last = lastStack.remove(lastStack.size() - 1);
			else
				last = null;
		}

		for (int i = 0; i < len; i++) {
			if (markers[i] != null)
				newPoints.add(points[i]);
		}

		return newPoints.toArray(new float[newPoints.size()][2]);
	}*/
	
	public static DoubleBuilder simplifyDouglasPeucker(DoubleBuilder points, double sqTolerance) {
        int last = points.size() / 2 - 1;

        DoubleBuilder simplified = BuilderCreator.createDouble();
		
		simplified.append(points.get(0)).append(points.get(1));

        simplifyDPStep(points, 0, last, sqTolerance , simplified);
        simplified.append(points.get(last * 2)).append(points.get(last * 2 + 1));

        return simplified;
    }
	
	
	
	static void simplifyDPStep(DoubleBuilder points, int first, int last, double sqTolerance, DoubleBuilder simplified) {
		double maxSqDist = sqTolerance;
        int index = 0;

        for (int i = first + 1; i < last; i++) {
        	double sqDist = getSqSegDist(points.get(i * 2) , points.get(i * 2 + 1) , points.get(first * 2) , points.get(first * 2 + 1) , points.get(last * 2) , points.get(last * 2 + 1));
            if (sqDist > maxSqDist) {
                index = i;
                maxSqDist = sqDist;
            }
        }

        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                simplifyDPStep(points, first, index, sqTolerance, simplified);
            }

            simplified.append(points.get(index * 2));
            simplified.append(points.get(index * 2 + 1));

            if (last - index > 1) {
                simplifyDPStep(points, index, last, sqTolerance, simplified);
            }
        }
    }
	
	static double getSqSegDist(double pX,double pY,double p1X,double p1Y,double p2X,double p2Y) {

		double x = p1X,y = p1Y, dx = p2X - x,dy = p2Y - y;

        if (dx != 0 || dy != 0) {

        	double t = ((pX - x) * dx + (pY - y) * dy) / (dx * dx + dy * dy);

            if (t > 1) {
                x = p2X;
                y = p2Y;

            } else if (t > 0) {
                x += dx * t;
                y += dy * t;
            }
        }

        dx = pX - x;
        dy = pY - y;

        return dx * dx + dy * dy;
    }
	
	
	

	
}