/**
　 * <p>Title: AbstractType.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import org.apache.commons.lang3.StringUtils;

import com.northpool.commons.reflect.Bean;
import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public abstract class AbstractType implements Type {
        
    final TYPE_ENUM typeEnum;
    
    abstract public Class<?> getJavaClass();
    abstract public Boolean isTypePrimitive(Object o);
    abstract public Object toType(Object o);
    abstract public boolean isType(Object o);
    abstract public Object strToType(String str);
    
    public AbstractType( TYPE_ENUM typeEnum){
        this.typeEnum = typeEnum;
    }
    
    public TYPE_ENUM getEnum(){
        return this.typeEnum;
    }
    
    public String name() {
        return typeEnum.name();
    }

    
    
    public boolean typeIsNumber(){
        Class<?> clazz = this.getJavaClass();
        return Bean.isExtends(clazz, Number.class);
    }
    
    public boolean typeIsGeometry(){
        return false;
    }
    
    boolean stringNull(String str){
        if(str == null || "".equals(str)|| "null".equalsIgnoreCase(str)){
            return true;
        }else{
            return false;
        }
    }
    
    void testType(Type type,Object value){
        if(!type.isType(value)){
            throw new RuntimeException("类型错误;目标 " + value.toString() + "不是类型" + type.name());
        }
    }
    
    abstract Object nativeChange(Object o);
    
    abstract Object numberChange(Number o);
    
    Object numberToNumber(Object o){
        if(this.isTypePrimitive(o)){
            return nativeChange(o);
        }else{
            Number n = (Number)o;
            return numberChange(n);
        }
    }
    
    
    static String parseNumberE(String str){
        String[] values = StringUtils.split(str,"E");
        if(str.startsWith("0E")){
            return "0";
        }
        if(values.length == 2){
            String E = values[1];
            if(E.startsWith("-")){
                String V = values[0];
                int length = StringUtils.split(V,".")[1].length();
                java.text.NumberFormat NF = java.text.NumberFormat.getInstance();
                NF.setMinimumFractionDigits(Integer.valueOf(E.substring(1, E.length())) + length);
                NF.setGroupingUsed(false);
                return NF.format(Double.valueOf(str));
            }else{
                String V = values[0];
                int length = StringUtils.split(V,".")[1].length();
                java.text.NumberFormat NF = java.text.NumberFormat.getInstance();
                NF.setMaximumFractionDigits(Integer.valueOf(E) + length);
                NF.setGroupingUsed(false);
                return NF.format(Double.valueOf(str));
            }
        }else{
            return str;
        }
    }
    
    
    Object numberToType(Object o){
        if(o == null){
            return null;
        }
        if(this.isType(o)){
            return o;
        }
        if(TypeBoolean.INSTANCE.isType(o)){
            return TypeBoolean.INSTANCE.booleanToNumber((Type)this, o);
        }
        Type type = Types.isNumber(o);
        
        if(type != null){
            return this.numberToNumber(o);
        }
        
        return this.strToType(o.toString());
    }
    
   
    public String getIsTypeScript(){
        return " return " + this.getClass().getName() + ".INSTANCE;";
    }
   
    
}
