/**
 * <p>
 * Title: Type.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 * @author matt @date 2021年6月18日 @version 1.0
 */
package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public interface Type {
    
    
    public TYPE_ENUM getEnum();
    
    public boolean typeIsGeometry();

    public boolean typeIsNumber();

    /**
     * 类型名称
     * 
     * @return
     */
    public String name();

    /**
     * 对应JAVA类型
     * 
     * @return
     */
    public Class<?> getJavaClass();

    /**
     * 是否是改类型
     * 
     * @param o
     * @return
     */
    public boolean isType(Object o);

    /**
     * string转类型
     * 
     * @param str
     * @return
     */
    public Object strToType(String str);

    /**
     * 类型转string
     * 
     * @param o
     * @return
     */
    public String valueToString(Object o);

    /**
     * 为止类型转换为该类型
     * 
     * @param o
     * @return
     */
    public Object toType(Object o);
    
    /**
     * 是否是该类型的基础类则返回true,如果不是该类型或该类型没有基础类返回false;
     * @param o
     * @return
     */
    public Boolean isTypePrimitive(Object o);
    
    /**
     * 获得判断脚本
     * @return
     */
    public String getIsTypeScript();

}
