/**
　 * <p>Title: TypeBigDecimal.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import java.math.BigDecimal;

import com.northpool.exception.NotSupport;
import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public class TypeBigDecimal extends AbstractType implements Type {
    /**
     * @param typeEnum
     */
    public TypeBigDecimal() {
        super(TYPE_ENUM.BigDecimal);
    }

    public static final TypeBigDecimal INSTANCE = new TypeBigDecimal();

    
    @Override
    public Class<?> getJavaClass() {
        // TODO Auto-generated method stub
        return BigDecimal.class;
    }

    
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof BigDecimal;
    }

   
    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        str = parseNumberE(str);
        return new BigDecimal(str);
    }

    
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return parseNumberE(o.toString());
    }

   
    @Override
    public Object toType(Object o) {
        // TODO Auto-generated method stub
        if(o == null){
            return null;
        }
        // TODO Auto-generated method stub
        if(this.isType(o)){
            return o;
        }

        return this.strToType(parseNumberE(o.toString()));
        
    }

    
    @Override
    public Boolean isTypePrimitive(Object o) {
        // TODO Auto-generated method stub
        return false;
    }

    
    @Override
    Object nativeChange(Object o) {
        throw new NotSupport();
    }

  
    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }

}
