/**
　 * <p>Title: TypeBytes.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月21日
　 * @version 1.0
*/
package com.northpool.type;

import com.northpool.exception.NotSupport;
import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public class TypeBytes  extends AbstractType implements Type {

    
    public static final TypeBytes INSTANCE = new TypeBytes();

    /**
     * @param typeEnum
     */
    public TypeBytes() {
        super(TYPE_ENUM.Bytes);
    }

    
    @Override
    public Class<?> getJavaClass() {
        // TODO Auto-generated method stub
        return byte[].class;
    }

  
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return (o instanceof byte[] || o instanceof Byte[]);
    }

  
    @Override
    public Object strToType(String str) {
        // TODO Auto-generated method stub
        return null;
    }

  
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this, o);
        byte[] bytes = (byte[])o;
        return new String(bytes);
    }

   
    @Override
    public Object toType(Object o) {
        if(o == null){
            return null;
        }
        if(this.isType(o)){
            return o;
        }else{
            if(o instanceof String){
                return this.strToType(o.toString());
            }else{
                throw new RuntimeException("不能将" + o + "转换为bytes");
            }
        }
    }

 
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(boolean.class);
    }

  
    @Override
    Object nativeChange(Object o) {
        return (byte[])o;
    }

    
    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }

}
