package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

public class TypeDouble extends AbstractType implements Type {

    
    public TypeDouble() {
        super(TYPE_ENUM.Double);
    }


    public static final TypeDouble INSTANCE = new TypeDouble();
    
    
    @Override
    public String name() {
        return Types.TYPE_ENUM.Double.name();
    }

  
    @Override
    public Class<?> getJavaClass() {
        return Double.class;
    }

    
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Double;
    }

    
    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        str = parseNumberE(str);
        return new Double(str).doubleValue();
    }

    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return parseNumberE(o.toString());
    }

   
    @Override
    public Object toType(Object o) {
        return numberToType(o);
    }


    
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(double.class);
    }


    
    @Override
    Object nativeChange(Object o) {
        return (double)o;
    }


    @Override
    Object numberChange(Number o) {
        return o.doubleValue();
    }

}
