/**
　 * <p>Title: TypeEnum.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月23日
　 * @version 1.0
*/
package com.northpool.type;

import org.apache.commons.lang3.StringUtils;

import com.northpool.commons.reflect.Bean;
import com.northpool.exception.NotSupport;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public class TypeEnum extends AbstractType implements Type {
    /**
     * @param typeEnum
     */
    public TypeEnum() {
        super(TYPE_ENUM.Enum);
    }

    public static TypeEnum INSTANCE = new TypeEnum();

   
    @Override
    public Class<?> getJavaClass() {
        return Enum.class;
    }

    
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Enum;

    }

   
    @Override
    public Object strToType(String str) {
        // TODO Auto-generated method stub
        String[] classNameArray = StringUtils.split("|");
        String className = classNameArray[0];
        
        try {
            Class clazz = Bean.getClassByName(className);
            return  Enum.valueOf(clazz, str);
        } catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException("转换" + str + "失败,没有找到类:" + className);
        }
        
    }

   
    @Override
    public String valueToString(Object o) {
        Enum e = (Enum)o; 
        if(e == null){
            return null;
        }
        return o.getClass().getName() + "|" + e.name();

    }

   
    @Override
    public Object toType(Object o) {
        // TODO Auto-generated method stub
      
        return null;
    }

   
    @Override
    public Boolean isTypePrimitive(Object o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }

   
    @Override
    Object nativeChange(Object o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }

   
    @Override
    Object numberChange(Number o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }
    
    public static void main(String [] aaa){
       
       System.out.print( TypeEnum.INSTANCE.valueToString(SPATIAL_TYPE.hexwkb));
        
    }
}
