/**
　 * <p>Title: TypeFloat.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public class TypeFloat extends AbstractType implements Type{
    
    public TypeFloat() {
        super(TYPE_ENUM.Float);
    }


    public static final TypeFloat INSTANCE = new TypeFloat();

    
    @Override
    public Class<?> getJavaClass() {
        // TODO Auto-generated method stub
        return Float.class;
    }

    
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Float;
    }

    
    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        str = parseNumberE(str);
        return new Float(str).floatValue();
    }

    
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return parseNumberE(o.toString());
        
    }

    
    @Override
    public Object toType(Object o) {
        return numberToType(o);
    }

    
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(float.class);
    }

    
    @Override
    Object nativeChange(Object o) {
        return (float)o;
    }

    
    @Override
    Object numberChange(Number o) {
        return o.floatValue();
    }
}
