/**
　 * <p>Title: GeometryType.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月21日
　 * @version 1.0
*/
package com.northpool.type;

import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.exception.NotSupport;
import com.northpool.spatial.Geom;
import com.northpool.type.Types.TYPE_ENUM;

/**
 * @author matt
 *
 */
public abstract class TypeGeometry extends AbstractType implements Type {

    
    abstract public SPATIAL_TYPE getSpatialType();
    
   // public static final TypeGeometry INSTANCE = new TypeGeometry();

    /**
     * @param typeEnum
     */
    public TypeGeometry() {
        super(TYPE_ENUM.Geometry);
    }

    
    @Override
    public Class<?> getJavaClass() {
        return Geom.class;
    }

    
    public boolean isType(Object o){
        if(o == null){
            return false;
        }
        if(o instanceof Geom){
            return ((Geom)o).getType() == this.getSpatialType();
        }else{
            return false;
        }
        
    }
    
    

   
    @Override
    public Object strToType(String str) {
        this.stringNull(str);
        return new Geom(SPATIAL_TYPE.wkt,str);
    }

    
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this, o);
        Geom geom = (Geom)o;
        return geom.toWkt();
    }

    
    @Override
    public Object toType(Object o) {
        if(o == null){
            return null;
        }
        
        if(!(o instanceof Geom)){
            throw new RuntimeException("转换类型必须为Geom");
        }
        
        Geom geom = (Geom)o;
        geom.changeType(this.getSpatialType());
        return geom;
        
//        throw new NotSupport();
    }

   
    @Override
    public Boolean isTypePrimitive(Object o) {
        // TODO Auto-generated method stub
        return false;
    }

    
    @Override
    Object nativeChange(Object o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }

   
    @Override
    Object numberChange(Number o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }

    public String getIsTypeScript(){
        StringBuilder sb = new StringBuilder();
        sb.append("com.northpool.spatial.Geom geom = (com.northpool.spatial.Geom)obj;");
        sb.append("if(geom.getType() == ").append(this.getClass().getName()).append(".INSTANCE.getSpatialType()){");
        sb.append("return ").append(this.getClass().getName()).append(".INSTANCE;");
        sb.append("};");
        return sb.toString();
    }
    
    
}
