package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

public class TypeInteger extends AbstractType implements Type {
    
   
    public TypeInteger() {
        super(TYPE_ENUM.Integer);
    }


    public static final TypeInteger INSTANCE = new TypeInteger();
    
    @Override
    public String name() {
        return Types.TYPE_ENUM.Integer.name();
    }

   
    @Override
    public Class<?> getJavaClass() {
        return Integer.class;
    }

   
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        if(o instanceof Integer){
            return true;
        }
        return false;
    }

 
    @Override
    public Object strToType(String str) {
     // TODO Auto-generated method stub
        if(this.stringNull(str)){
            return null;
        }
        str = parseNumberE(str);
        return new Integer(str).intValue();
        
    }

   
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return o.toString();
        
    }

   
    @Override
    public Object toType(Object o) {
        return numberToType(o);
    }
    
    public Boolean isTypePrimitive(Object o){
        return o.getClass().equals(int.class);
    }


   
    @Override
    Object nativeChange(Object o) {
        return (int)o;
    }


   
    @Override
    Object numberChange(Number o) {
        return o.intValue();
    }
	
	
}
