/**
　 * <p>Title: TypeManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;

import com.northpool.commons.reflect.Bean;
import com.northpool.commons.util.PackageUtil;


import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

/**
 * @author matt
 *
 */ 
class TypeManager {
    
    static List<Type> _TMP_TYPE_LIST = new ArrayList<Type>();
    static Set<Type> typeSet = new HashSet<Type>();
    static HashMap<Class<?>,Type> classTypeMap = new HashMap<>();
    static GetType GET_TYPE;
    static{
        try{
            
            Set<Class<?>> classSet = PackageUtil.findClassByInterface(new String[]{"com.northpool.type"}, Type.class);
            
            classSet.forEach( clazz ->{
                try{
                    if(Bean.isAbstract(clazz)){
                        return;
                    }
                    
                    Field field = clazz.getDeclaredField("INSTANCE");
                    Type type = (Type) field.get(null);
                   
                    if(type.getJavaClass() != null){
                        typeSet.add(type);
                        classTypeMap.put(type.getJavaClass(), type);
                    }
                }catch(Exception e){
                    throw new RuntimeException("类" + clazz.getName() + " 没有找到静态属性INSTANCE,TYPES创建失败");   
                }
            });
        	
        
            
        	
        	
            
            /*typeSet.add(TypeBigDecimal.INSTANCE);
            classTypeMap.put(TypeBigDecimal.INSTANCE.getJavaClass(), TypeBigDecimal.INSTANCE);
            
            typeSet.add(TypeBoolean.INSTANCE);
            classTypeMap.put(TypeBoolean.INSTANCE.getJavaClass(), TypeBoolean.INSTANCE);
            
            typeSet.add(TypeBytes.INSTANCE);
            classTypeMap.put(TypeBytes.INSTANCE.getJavaClass(), TypeBytes.INSTANCE);
            
            typeSet.add(TypeDouble.INSTANCE);
            classTypeMap.put(TypeDouble.INSTANCE.getJavaClass(), TypeDouble.INSTANCE);
            
            typeSet.add(TypeEnum.INSTANCE);
            classTypeMap.put(TypeEnum.INSTANCE.getJavaClass(), TypeEnum.INSTANCE);
            
            typeSet.add(TypeFloat.INSTANCE);
            classTypeMap.put(TypeFloat.INSTANCE.getJavaClass(), TypeFloat.INSTANCE);
        	

            typeSet.add(TypeInteger.INSTANCE);
            classTypeMap.put(TypeInteger.INSTANCE.getJavaClass(), TypeInteger.INSTANCE);
            
            typeSet.add(TypeLong.INSTANCE);
            classTypeMap.put(TypeLong.INSTANCE.getJavaClass(), TypeLong.INSTANCE);
            
            typeSet.add(TypeShort.INSTANCE);
            classTypeMap.put(TypeShort.INSTANCE.getJavaClass(), TypeShort.INSTANCE);
            
            typeSet.add(TypeString.INSTANCE);
            classTypeMap.put(TypeString.INSTANCE.getJavaClass(), TypeString.INSTANCE);
            
            typeSet.add(TypeTimestamp.INSTANCE);
            classTypeMap.put(TypeTimestamp.INSTANCE.getJavaClass(), TypeTimestamp.INSTANCE);
            

            typeSet.add(TypeVoid.INSTANCE);
            classTypeMap.put(TypeVoid.INSTANCE.getJavaClass(), TypeVoid.INSTANCE);*/
            
            
            StringBuilder stringBuilder = new StringBuilder();
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass("com.northpool.temp.getType" + UUID.randomUUID().toString());
            ctClass.setInterfaces(new CtClass[]{pool.makeInterface(GetType.class.getName())});
            String methodName = null;
            Method[] methods = GetType.class.getDeclaredMethods();
            for(Method m : methods){
                if(m.getGenericReturnType().equals(Type.class)){
                    methodName = m.getName();
                }
            }
            if(methodName == null){
                throw new RuntimeException("GetType 接口中没有对应的函数");
            }
            stringBuilder.append("public ").append(Type.class.getName()).append(' ').append(methodName).append("(java.lang.Object obj){");
            
            for(Type type: typeSet){
                CannotTranstype cannotTranstype = type.getClass().getAnnotation(CannotTranstype.class);
                if(cannotTranstype != null){
                    continue;
                }
                Class<?> c = type.getJavaClass();
                String javaClassName;
                
                javaClassName = type.getJavaClass().getName();
                if("[B".equals(javaClassName)){
                    javaClassName = "byte[]";
                }
                
                stringBuilder.append("if(obj instanceof ").append(javaClassName).append("){").append(type.getIsTypeScript()).append("};");
            }
            stringBuilder.append("return com.northpool.type.TypeUnknown.INSTANCE;}");
            //ClassPool使用上下文类加载器，此处设置上下文加载器与GetType的加载器一致，避免下面强转失败的异常
            Thread.currentThread().setContextClassLoader(GetType.class.getClassLoader());

            //System.out.println(stringBuilder.toString());
            CtMethod method = CtNewMethod.make(stringBuilder.toString(),ctClass);
            ctClass.addMethod(method);
            Class<?> clazz = ctClass.toClass();
            GET_TYPE = (GetType) clazz.newInstance();
        }catch(Exception e){
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
    static final List<Type> TYPE_LIST = (List<Type>) Collections.unmodifiableList(_TMP_TYPE_LIST);
    
    
    
    
    
    
    
    /**
     * 获得基础类型
     * @param wraperClass
     * @return
     */
    static Class<?> getPrimitiveType(Class<?> wraperClass) {
        if (wraperClass.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (wraperClass.equals(Short.class)) {
            return Short.TYPE;
        }
        if (wraperClass.equals(Long.class)) {
            return Long.TYPE;
        }
        if (wraperClass.equals(Float.class)) {
            return Float.TYPE;
        }
        if (wraperClass.equals(Double.class)) {
            return Double.TYPE;
        }
        if (wraperClass.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (wraperClass.equals(Character.class)) {
            return Character.TYPE;
        }
        if (wraperClass.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (wraperClass.equals(Void.class)) {
            return Void.TYPE;
        }
        return wraperClass;
    }
    
    
    
    /**
     * 获得封装类
     * @param toClass
     * @return
     */
    static Class<?> getWraper(Class<?> toClass) {
        if (toClass.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (toClass.equals(Short.TYPE)) {
            return Short.class;
        }
        if (toClass.equals(Long.TYPE)) {
            return Long.class;
        }
        if (toClass.equals(Float.TYPE)) {
            return Float.class;
        }
        if (toClass.equals(Double.TYPE)) {
            return Double.class;
        }
        if (toClass.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (toClass.equals(Character.TYPE)) {
            return Character.class;
        }
        if (toClass.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (toClass.equals(Void.TYPE)) {
            return Void.class;
        }
        
        
        return toClass;
    }
    
    /**
     * 是否是基础封装类
     * @param toClass
     * @return
     */
    static boolean isWraper(Class<?> toClass) {
        if (toClass.equals(Integer.class)) {
            return true;
        }
        if (toClass.equals(Short.class)) {
            return true;
        }
        if (toClass.equals(Long.class)) {
            return true;
        }
        if (toClass.equals(Float.class)) {
            return true;
        }
        if (toClass.equals(Double.class)) {
            return true;
        }
        if (toClass.equals(Byte.class)) {
            return true;
        }
        if (toClass.equals(Character.class)) {
            return true;
        }
        if (toClass.equals(Boolean.class)) {
            return true;
        }
        if (toClass.equals(Void.class)) {
            return true;
        }
        return false;
    }
    
    

}
