package com.northpool.type;

import com.northpool.exception.NotSupport;

public class TypeString extends AbstractType implements Type{
    
    
    public static final TypeString INSTANCE = new TypeString();
    
    /**
     * @param typeEnum
     */
    public TypeString() {
        super(Types.TYPE_ENUM.String);
    }

  
    @Override
    public Class<?> getJavaClass() {
        return String.class;
    }

   
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        if(o instanceof String){
            return true;
        }
        return false;
    }

   
    @Override
    public Object strToType(String str) {
        return str;
    }

   
    @Override
    public String valueToString(Object o) {
        // TODO Auto-generated method stub
        if(o == null){
            return "";
        }
        this.testType(this,o);
        return o.toString();
    }

    @Override
    public Object toType(Object o) {
        if(o == null){
            return null;
        }
        if(this.isType(o)){
            return o;
        }else{
            return o.toString();
        }
    }
    
    public Boolean isTypePrimitive(Object o){
        return false;
    }


    
    @Override
    Object nativeChange(Object o) {
        // TODO Auto-generated method stub
       throw new NotSupport();
    }


   
    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }
	
	
}
