/**
 * <p>
 * Title: TypeTimestamp.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 * 
 * @author matt @date 2021年6月21日 @version 1.0
 */
package com.northpool.type;

import com.northpool.exception.NotSupport;
import com.northpool.type.Types.TYPE_ENUM;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;

/**
 * @author matt
 *
 */
public class TypeTimestamp extends AbstractType implements Type {
    /**
     * @param typeEnum
     */
    public TypeTimestamp() {
        super(TYPE_ENUM.Timestamp);
    }

    public static final TypeTimestamp INSTANCE = new TypeTimestamp();

    @Override
    public Class<?> getJavaClass() {
        return Date.class;
    }

    @Override
    public boolean isType(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Date;
    }

    @Override
    public Object strToType(String str) {
        // TODO Auto-generated method stub
        if (this.stringNull(str)) {
            return null;
        }
        Date value;
        try {
            value = DateUtils.parseDate(str, new String[] {"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd",
                "yyyy-MM-dd HH:mm:ss", "yyyy年MM月dd日", "yyyy-MM"});
            return value;
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException(
                str + "不能转换成日期类型,日期转换格式为:'yyyy-MM-dd','yyyy-MM-dd HH:mm:ss','yyyy年MM月dd日','yyyy-MM'");
        }
    }

    public Object strToType(String str, String dateFormat) {
        // TODO Auto-generated method stub
        if (this.stringNull(str)) {
            return null;
        }
        Date value;
        try {
            value = DateUtils.parseDate(str, new String[] {dateFormat});
            return value;
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException(str + "不能转换成日期类型,日期转换格式为:" + dateFormat);
        }
    }

    
    public String valueToString(Object o, String dateFormat) {
        if (o == null) {
            return null;
        }
        SimpleDateFormat formatdate;
        formatdate = new SimpleDateFormat(dateFormat);
        return formatdate.format(o);
    }
    
    public String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        SimpleDateFormat formatdate;
        formatdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return formatdate.format(o);
    }

    @Override
    public Object toType(Object o) {
        if(o == null){
            return null;
        }
        // TODO Auto-generated method stub
        if(this.isType(o)){
            return o;
        }else{
            return this.strToType(o.toString());
        }
    }

    @Override
    public Boolean isTypePrimitive(Object o) {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    Object nativeChange(Object o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }

    @Override
    Object numberChange(Number o) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }
}
