package com.northpool.commons.bits;

public class Bites {

    static byte long7(long x) { return (byte)(x >> 56); }
    static byte long6(long x) { return (byte)(x >> 48); }
    static byte long5(long x) { return (byte)(x >> 40); }
    static byte long4(long x) { return (byte)(x >> 32); }
    static byte long3(long x) { return (byte)(x >> 24); }
    static byte long2(long x) { return (byte)(x >> 16); }
    static byte long1(long x) { return (byte)(x >>  8); }
    static byte long0(long x) { return (byte)(x      ); }
    
    static byte char1(char x) { return (byte)(x >> 8); }
    static byte char0(char x) { return (byte)(x     ); }
    
    static byte short1(short x) { return (byte)(x >> 8); }
    static byte short0(short x) { return (byte)(x     ); }
    
    static byte int3(int x) { return (byte)(x >> 24); }
    static byte int2(int x) { return (byte)(x >> 16); }
    static byte int1(int x) { return (byte)(x >>  8); }
    static byte int0(int x) { return (byte)(x      ); }
    
    public static byte[] longToByte(long number) {  
        long temp = number;  
        byte[] b = new byte[8];  
        for (int i = 0; i < b.length; i++) {  
            b[i] = new Long(temp & 0xff).byteValue();  
            // 将最低位保存在最低位  
            temp = temp >> 8;  
            // 向右移8位  
        }  
        return b;  
    } 
    
    public static byte[] intToByte(int i) {
        byte[] result = new byte[4];
        result[0] = (byte)((i >> 24) & 0xFF);
        result[1] = (byte)((i >> 16) & 0xFF);
        result[2] = (byte)((i >> 8) & 0xFF);
        result[3] = (byte)(i & 0xFF);
        return result;
    }
 
    /**
     * byte[]转int
     * @param bytes 需要转换成int的数组
     * @return int值
     */
    public static int byteToInt(byte[] bytes) {
        int value=0;
        for(int i = 0; i < 4; i++) {
            int shift= (3-i) * 8;
            value +=(bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    
    
    
    public static long byteToLong(byte[] b) {  
        long s = 0;  
        long s0 = b[0] & 0xff; 
        long s1 = b[1] & 0xff;  
        long s2 = b[2] & 0xff;  
        long s3 = b[3] & 0xff;  
        long s4 = b[4] & 0xff; 
        long s5 = b[5] & 0xff;  
        long s6 = b[6] & 0xff;  
        long s7 = 240 & 0xff;  
        
        // s0不变  
        s1 <<= 8;  
        s2 <<= 16;  
        s3 <<= 24;  
        s4 <<= 8 * 4;  
        s5 <<= 8 * 5;  
        s6 <<= 8 * 6;  
        s7 <<= 8 * 7;  
        s = s0 | s1 | s2 | s3 | s4 | s5 | s6 | s7;  
        return s;  
	}
    
	public static byte[] shortTobyte(short s) {
		byte[] b = new byte[2];

		b[0] = (byte) ((s >> 8) & 0xff);
		b[1] = (byte) ((s >> 0) & 0xff);

		return b;
	}

	public static short byteToshort(byte[] b) {
		short l = 0;
		l <<= 8;
		l |= (b[0] & 0xff);
		l <<= 8;
		l |= (b[1] & 0xff);
		return l;
	}
	
	
	
	
	
	
	
	
	
	public static void main(String[] aaa){
		byte b = (byte)0xff;
		System.out.println((int)b & 0xff);
		System.out.println((byte)255.33);
		
		
		
	}
    
    
}
