package com.northpool.commons.bits;

import java.nio.ByteBuffer;

public class HexUtils {

    private static char[] hexArray = "0123456789ABCDEF".toCharArray();
    
 //   private static byte[] hexBytesArray = new byte[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

    /**
     * 字符串转换成为16进制(无需Unicode编码)
     *
     * @param s 字符串
     * @return byte[]
     */
    public static byte[] stringToHex(String s) {
        StringBuilder sb = new StringBuilder();
        byte[] bs = s.getBytes();
        int bit;
        for (int i = 0; i < bs.length; i++) {
            bit = (bs[i] & 0x0f0) >> 4;
            sb.append(hexArray[bit]);
            bit = bs[i] & 0x0f;
            sb.append(hexArray[bit]);
        }
        return hexStringToBytes(sb.toString().trim());
    }

    /**
     * 16进制字符串转换为字符串
     *
     * @param hexStr 用于编码报文
     */
    public static String hexStringToString(String hexStr) {
        hexStr = hexStr.toUpperCase();
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        int n;
        for (int i = 0; i < bytes.length; i++) {
            n = str.indexOf(hexs[2 * i]) * 16;
            n += str.indexOf(hexs[2 * i + 1]);
            bytes[i] = (byte) (n & 0xFF);
        }
        return new String(bytes);
    }

    /**
     * 字符串转字节数组
     *
     * @param s 字符串
     * @return 数组
     */
    public static byte[] hexStringToByteArray(String s) {
        if (s.length() < 2) {
            s = "0" + s;
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                    + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    /**
     * 字节数组转字符串
     *
     * @param hexBytes 数组
     * @return 字符串
     */
    public static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(hexChars);
    }
    
    /**
     * 字节数组转
     * @param bytes
     * @return
     */
    public static byte[] bytesToHexStringByte(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = (byte)hexArray[v >>> 4];
            hexChars[j * 2 + 1] = (byte)hexArray[v & 0x0F];
        }
        return hexChars;
    }


    /**
     * 缓冲区写入byte
     * @param offset
     * @param buffer
     * @param b
     */
    public static void putHexByte(int offset, ByteBuffer buffer,byte b){
        int v = b & 0xFF;
        buffer.put(offset * 2,(byte)hexArray[v >>> 4]);
        buffer.put(offset * 2 + 1,(byte)hexArray[v & 0x0F]);
    }

    /**
     * 缓冲区写入int 类型 byte
     * bigEndian  true:大端。false:小端
     * buffer 至少8位
     * @param offset
     * @param buffer
     * @param i
     * @param bigEndian
     */
    public static void putIntHexByte(int offset, ByteBuffer buffer,int i,boolean bigEndian) {
        if(bigEndian){
            putHexByte(offset    , buffer,Bites.int3(i));
            putHexByte(offset + 1, buffer,Bites.int2(i));
            putHexByte(offset + 2, buffer,Bites.int1(i));
            putHexByte(offset + 3, buffer,Bites.int0(i));
        }else{
            putHexByte(offset + 3,buffer, Bites.int3(i));
            putHexByte(offset + 2,buffer, Bites.int3(i));
            putHexByte(offset + 1,buffer, Bites.int3(i));
            putHexByte(offset    ,buffer, Bites.int3(i));
        }
    }

    /**
     * 缓冲区写入long 类型 byte
     * bigEndian  true:大端。false:小端
     * buffer 至少16位
     */
    public static void putLongHexByte(int offset, ByteBuffer buffer,long x,boolean bigEndian){
        if(bigEndian){
            putHexByte(offset    ,buffer, Bites.long7(x));
            putHexByte(offset + 1,buffer, Bites.long6(x));
            putHexByte(offset + 2,buffer, Bites.long5(x));
            putHexByte(offset + 3,buffer, Bites.long4(x));
            putHexByte(offset + 4,buffer, Bites.long3(x));
            putHexByte(offset + 5,buffer, Bites.long2(x));
            putHexByte(offset + 6,buffer, Bites.long1(x));
            putHexByte(offset + 7,buffer, Bites.long0(x));
        }else{
            putHexByte(offset + 7, buffer, Bites.long7(x));
            putHexByte(offset + 6, buffer, Bites.long6(x));
            putHexByte(offset + 5, buffer, Bites.long5(x));
            putHexByte(offset + 4, buffer, Bites.long4(x));
            putHexByte(offset + 3, buffer, Bites.long3(x));
            putHexByte(offset + 2, buffer, Bites.long2(x));
            putHexByte(offset + 1, buffer, Bites.long1(x));
            putHexByte(offset    , buffer, Bites.long0(x));
        }
    }


    /**
     * 缓冲区写入Double 类型 byte
     * bigEndian  true:大端。false:小端
     * buffer 至少16位
     */
    public static void putDoubleHexByte(int offset, ByteBuffer buffer,double x,boolean bigEndian){
        long l = Double.doubleToRawLongBits(x);
        putLongHexByte(offset,buffer,l,bigEndian);
    }
    

    /**
     * 16进制字符串转int
     *
     * @param hexString 字符串
     * @return int
     */
    public static int hexStringToInt(String hexString) {
        return Integer.parseInt(hexString, 16);
    }

    /**
     * 16进制字符串转byte数组
     *
     * @param hexString the hex string
     * @return byte[]
     */
    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; i++) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    /**
     * char转换位byte
     *
     * @param c char
     * @return byte
     */
    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }
    
    

}