package com.northpool.commons.bits;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class UNumber {
	public static long toUint32(int l){
        return l & 0xffffffffL;
    }
	
	public static int toUint16(int n){
		return n & 0x0000ffff;
	}
	
	
	
	
	public static int getUint8(ByteBuffer buffer,int index){
		byte b = buffer.get(index);
		return (int)b & 0xff;
	}
	
	public static void putUint8(ByteBuffer buffer,int index,int value){
		buffer.put(index, (byte)value);
	}
	
	
	
	
	
	
	
	public static long toUint64(long n){
		byte[] bytes = Bites.longToByte(n);
		if(n > 0){
			return n;
		}else{
			byte[] b = new byte[9];
			System.arraycopy(bytes, 0, b, 1, bytes.length);
	        return new BigInteger(b).longValue();
		}
	}
	
	
}
