package com.northpool.commons.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import java.nio.ByteBuffer;
import java.util.HashMap;

import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * 内存jar包
 * 
 *
 */
public class MemoryJar {
	/**
	 * JAR包名称
	 */
	protected String name;
	/**
	 * jar包中资源的列表
	 */
	//protected ArrayList<String> resourceList = new ArrayList<String>();
	/**
	 * 资源名称为KEY的map
	 */
	protected HashMap<String,ByteBuffer> resourceMap = new HashMap<String,ByteBuffer>();
	
	
	public MemoryJar(String name,byte[] bytes) throws IOException{
		this.name = name;
		this.init(name, bytes);
		
	}
	public String getName(){
		return this.name;
	} 
	
	
	/*public ByteBuffer getClass(String className){
	    ByteBuffer b = this.classMap.get(className);
		if(b == null){
			return null;
		}else{
			//return 
			return b;
		}
		
	}*/
	
	protected ByteBuffer createBuffer(byte[] byte_s_){
	    ByteBuffer buffer = ByteBuffer.allocateDirect(byte_s_.length);
	    buffer.put(byte_s_);
	    return buffer;
	}
	
	protected void init(String jarName,byte[] jarByte) throws IOException{
		
		ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(jarByte));

		ZipEntry entry;
        while((entry = zis.getNextEntry())!=null){
        	if(entry.isDirectory()){
        		continue;
        	}
        	String fileName_zip = entry.getName();

        	ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        	byte[] byte_s = new byte[1024];
        	int num = -1;
        	while((num = zis.read(byte_s,0,byte_s.length))>-1){
        		byteArrayOutputStream.write(byte_s,0,num);
        	}

        	byte[] byte_s_ = byteArrayOutputStream.toByteArray();
        	String resourceUrl = MemoryClassLoader.createURIPath(fileName_zip);
        	ByteBuffer buffer = this.createBuffer(byte_s_);
        	this.resourceMap.put(resourceUrl, buffer);
        	/*if(fileName_zip.endsWith(".class")){
                this.classMap.put(fileName_zip, resourceUrl);
            }*/
        	byteArrayOutputStream.close();           
        }
        zis.close();	
	}
	
	/*public List<URL> findResources(String resourcesName) throws IOException{
		List<URL> list = new ArrayList<URL>();
		for(String resource : this.resourceMap.keySet()){
			if(resource.startsWith(resourcesName)){
				String uri = this.createURI(this.name, resourcesName);
				URL url = new URL(uri);
				URL url1 = new URL(url, uri, new URLStreamHandler() {
					@Override
					protected URLConnection openConnection(URL u) throws IOException {
						return new MemoryURLConnection(url, uri, resourceMap.get(uri));
					}
				});

				list.add(url1);
				break;
			}
		}
		return list;
	}*/
	
	public HashMap<String,ByteBuffer> getAllResources(){
		 return this.resourceMap;
	}
	
	
	
//	public List<String> getAllResourcesURL(){
//		List<String> list = new ArrayList<String>();
//		for(String resource : this.resourceMap.keySet()){
//			String path = this.createURI(this.name, resource);
//			list.add(path);	
//		}
//		return list;
//	}
	
	
	
}
