/**
　 * <p>Title: ByteBuilder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年4月16日
　 * @version 1.0
*/
package com.northpool.commons.collection.builder;

import com.northpool.commons.util.UnsafeFuntion;

/**
 * 
 *
 */
public class ByteBuilder extends AbstractBuilder<byte[]> implements Builder<byte[]> {

   
    
    public ByteBuilder(){
        super();
    }
    
    
    /**
     * @param arr
     */
    public ByteBuilder(byte[] arr) {
        // TODO Auto-generated constructor stub
        super(arr);
    }
    
    public ByteBuilder(int size) {
        // TODO Auto-generated constructor stub
        super(size);
    }


    @Override
    public Builder<byte[]> append(byte[] arr) {
        // TODO Auto-generated method stub
        return (ByteBuilder)super.append(arr, 0, arr.length);
    }

   
    @Override
    public ByteBuilder append(byte[] arr, int offset, int length) {
        // TODO Auto-generated method stub
        return (ByteBuilder)super.append(arr, offset, length);
    }

    
    @Override
    byte[] createHeap(int size) {
        // TODO Auto-generated method stub
        return new byte[size];
    }
    
    public byte get(int index) {
        if (this.isDirect) {
            index = index * this.typeSize;
            int dataBlockIndex = (int)(index / this.directApplySize);
            int bindex = index % this.directApplySize;
            return this.directBufferArr.get(dataBlockIndex).get(bindex);
        } else {
            return this.heap[index];
        }
    }
    
    public void set(int index,byte d){
        if(index >= this.size){
            throw new RuntimeException("out of range");
        }else{
            if(this.isDirect){
                index = index * this.typeSize;
                int dataBlockIndex = (int)(index / this.directApplySize);
                int bIndex = index % this.directApplySize;               
                this.directBufferArr.get(dataBlockIndex).put(bIndex,d);
            }else{
                this.heap[index] = d;
            }
        }
    }
    
    
    public ByteBuilder append(byte d) {
        
        int off = 1;
        if (this.size + off > this.capacity) {
            this.ensureCapacityInternal(1);
        }
        if(this.isDirect){
            this.currentDirectByteBuffer.put(d);
        }else{
            this.heap[this.size] = d;
        }
        this.size ++;
        
        return this;
    }
    

   
    @Override
    protected long getHeapTypeOffset() {
        return UnsafeFuntion.byteArrayOffset;
    }

   
    @Override
    protected int getHeapTypeOff() {
        // TODO Auto-generated method stub
        return 0;
    }

    /* (non-Javadoc)
     * @see com.northpool.commons.collection.builder.AbstractBuilder#getHeapSize(java.lang.Object)
     */
    @Override
    protected int getHeapSize(byte[] heap) {
        // TODO Auto-generated method stub
        return heap.length;
    }


    /* (non-Javadoc)
     * @see com.northpool.commons.collection.builder.AbstractBuilder#getTypeSize()
     */
    @Override
    int getTypeSize() {
        // TODO Auto-generated method stub
        return 1;
    }
    
    
    
    
    
}
    
   
