/**
　 * <p>Title: DoubleBuilder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年4月16日
　 * @version 1.0
*/
package com.northpool.commons.collection.builder;

import com.northpool.commons.util.UnsafeFuntion;

/**
 * 
 *
 */
public class DoubleBuilder extends AbstractBuilder<double[]> implements Builder<double[]>{

    
    
    
    public DoubleBuilder(){
        super();
    }
    
    
    public DoubleBuilder(double[] arr) {
        super(arr);
    }
    
    public DoubleBuilder(int size){
        super(size);
    }
    
    public double get(int index) {
        if (this.isDirect) {
            index = index * this.typeSize;
            int dataBlockIndex = (int)(index / this.directApplySize);
            int dbbIndex = index % this.directApplySize;
            return this.directBufferArr.get(dataBlockIndex).getDouble(dbbIndex);
            
        } else {
            return this.heap[index];
        }
    }

   
    @Override
    public DoubleBuilder append(double[] arr) {
        // TODO Auto-generated method stub
        return (DoubleBuilder)super.append(arr, 0, arr.length);
    }

    public DoubleBuilder append(double d) {
        
        int off = 1;
        if (this.size + off > this.capacity) {
            this.ensureCapacityInternal(1);
        }
        
        if(this.isDirect){
            this.currentDirectByteBuffer.putDouble(d);
        }else{
            this.heap[this.size] = d;
        }
        this.size ++;
        
        return this;
    }
    
   
    
    public DoubleBuilder append(double[] arr, int offset, int length) {
        // TODO Auto-generated method stub
        return (DoubleBuilder)super.append(arr, offset, length);
    }

   
    
    public void set(int index,double d){
        if(index >= this.size){
            throw new RuntimeException("out of range");
        }else{
            if(this.isDirect){
                index = index * this.typeSize;
                int dataBlockIndex = (int)(index / this.directApplySize);
                int dbbIndex = index % this.directApplySize;
                
                this.directBufferArr.get(dataBlockIndex).putDouble(dbbIndex,d);
            }else{
                this.heap[index] = d;
            }
        }
    }


   
    @Override
    double[] createHeap(int size) {
        
        return new double[size];
    }

   
    @Override
    protected long getHeapTypeOffset() {
        return UnsafeFuntion.doubleArrayOffset;
    }

    
    @Override
    protected int getHeapTypeOff() {
        return 3;
    }

    
    @Override
    protected int getHeapSize(double[] heap) {
        return heap.length;
    }


    /* (non-Javadoc)
     * @see com.northpool.commons.collection.builder.AbstractBuilder#getTypeSize()
     */
    @Override
    int getTypeSize() {
        // TODO Auto-generated method stub
        return 8;
    }
    
}
