/**
　 * <p>Title: DynamicCountDownLatch.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年10月19日
　 * @version 1.0
*/
package com.northpool.commons.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/**
 * 
 *
 */
public class DynamicCountDownLatch {

    final AtomicLong count = new AtomicLong(0);
    
    private static final class Sync extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int count) {
            setState(count);
        }

        synchronized void  _setState(int count){
            for (;;) {
                int c = getState();
                int nextc = c + count;
                if (compareAndSetState(c, nextc)){
                    return;
                }
            }
            
            
            
        }
        
        
        int getCount() {
            return getState();
        }

        protected int tryAcquireShared(int acquires) {
            return (getState() == 0) ? 1 : -1;
        }

        protected boolean tryReleaseShared(int releases) {
            // Decrement count; signal when transition to zero
            for (;;) {
                int c = getState();
                if (c == 0)
                    return false;
                int nextc = c - releases;
                if (compareAndSetState(c, nextc)){
                    return nextc == 0;
                }
            }
        }
    }

    private final Sync sync;

   
    public DynamicCountDownLatch(int num) {
     //   if (count < 0) throw new IllegalArgumentException("count < 0");
        this.sync = new Sync(num);
    }
    
    public DynamicCountDownLatch() {
        //   if (count < 0) throw new IllegalArgumentException("count < 0");
           this.sync = new Sync(0);
       }

    /**
     * await() 方法具有阻塞作用
     * 能够阻塞线程 直到调用N次countDown() 方法才释放线程
     */
    public void await() throws InterruptedException {
        sync.acquireSharedInterruptibly(1);
    }

    /**
     * 在指定时间内达到0 返回true 否则返回false
     */
    public boolean await(long timeout, TimeUnit unit)
        throws InterruptedException {
        return sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

   
    public void addNum(int num){
        
        sync._setState(num);
    }

    /**
     * countDown()是用来线程计数器-1的，也就是新增线程运行完之后，都调用此方法将计数器变成0，最后调用await()方法，主线程就会被唤醒，继续执行其它代码
     * 当计数器为o时在执行countDown(),计数器仍然为0
     */
    public void countDown(int num) {
        sync.releaseShared(num);
    }

    /**
     * 获取当前计数器值
     */
    public long getCount() {
        return sync.getCount();
    }

    
    public String toString() {
        return super.toString() + "[Count = " + sync.getCount() + "]";
    }
    
    public static void main(String[] aaa) throws InterruptedException{
        DynamicCountDownLatch count = new DynamicCountDownLatch(0);
        BlockThreadPool threadPool = new BlockThreadPool(2,1);
        count.addNum(8);
        for(int i = 0 ; i < 10 ; i ++){

            threadPool.execute( ()-> {
                try {
                    Thread.sleep(1 * 1000);
                } catch (InterruptedException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                System.out.println(count.getCount()+"----------------------a");
                count.countDown(1);

            });
        }
        count.await();
        System.out.println("aaaa");
        
    }
}
