/**
 * <p>
 * Title: FileChannelReader.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 *  @date 2020年10月21日 @version 1.0
 */
package com.northpool.commons.filechannel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.northpool.commons.util.FileUtil;
import com.northpool.commons.util.StringUtility;
import com.northpool.commons.util.ThreadLocalMD5;
import com.northpool.commons.util.UString;

/**
 * 
 *
 */
public class    MutilPartFileChannelReader implements AutoCloseable {
    private String infoJsonPath;
    private FileInfo fileInfo;
    private ThreadLocalMD5 MD5 = new ThreadLocalMD5();
    // private long bufferSize;
    private long offset = 0;
    private long size = 0;
    private  FileChannel currentReaderChannel;
    private int partIndex = 0;
    private int partNum;
    private String root = null;

    Logger logger = LoggerFactory.getLogger(MutilPartFileChannelReader.class);

    public MutilPartFileChannelReader(String infoJsonPath) throws Exception {
        this.infoJsonPath = infoJsonPath;
        // this.bufferSize = bufferSize;
        this.fileInfo = this.createFileInfo(this.infoJsonPath);
        this.init();
    }

    public MutilPartFileChannelReader(FileInfo fileInfo) throws Exception{
        this.fileInfo = fileInfo;
       // this.root = null;
      //  this.root = "aaa";
        this.init();
    }
    
    private void init() throws Exception {
        logger.debug("开始加载" + infoJsonPath);
        this.checkMD5(this.fileInfo);
        this.size = this.fileInfo.getPart().stream().mapToLong(SplitFilePart::getPartSize).sum();
        this.partNum = this.fileInfo.getPart().size();
        logger.debug(UString.format("分文件 {} 个，总大小为 {} ", this.partNum, StringUtility.getDataSize(this.size)));
    }

    private FileInfo createFileInfo(String infoJsonPath) throws UnsupportedEncodingException {
        this.root = Paths.get(infoJsonPath).getParent().toString();
        byte[] buffer = FileUtil.File2byte(infoJsonPath);
        FileInfo info = JSON.parseObject(new String(buffer, "utf-8"), FileInfo.class);
        return info;
    }

    private void checkMD5(FileInfo info) throws Exception {
        logger.debug("检查文件快MD5");
        List<String> exceptions = new ArrayList<>();
        for (SplitFilePart part : info.getPart()) {
            // String partName = part.getFileName();
            try {
                this.checkMD5(part);
            } catch (Exception e) {
                exceptions.add(e.getMessage());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new Exception(String.join(";", exceptions));
        }
    }

    private String getAbsolutePath(String part){
        if(this.root != null){
            return this.root + File.separator + part;
        }else{
            return part;
        }
    }
    
    
    private void checkMD5(SplitFilePart part) throws Exception {

        String filePart = this.getAbsolutePath(part.getFileName());
        logger.debug(UString.format("检查文件 {} md5", filePart));
        MD5.setFile(new File(filePart));
        String md5 = MD5.getMD5();
        if (!md5.equals(part.getMd5())) {
            throw new Exception(UString.format("文件块 {} md5码不符", part.getFileName()));
        }
    }

    private FileChannel getReaderChannel(String partName) throws FileNotFoundException {

        if (partName == null) {
            return null;
        }
        String filePart = this.getAbsolutePath(partName);
        logger.debug(UString.format("读取文件{}", partName));
        @SuppressWarnings("resource")
		FileChannel channel = new RandomAccessFile(filePart, "r").getChannel();
        return channel;
    }

    private String getFilePartByIndex(int index) {
        Optional<SplitFilePart> optional = this.fileInfo.getPart().stream().filter((part) -> {
            if (part.getIndex() == index) {
                return true;
            } else {
                return false;
            }
        }).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFileName();
        } else {
            return null;
        }
    }

    public synchronized int read(ByteBuffer buffer) throws Exception {
        // int bufferSize = buffer.capacity();
        if (this.partIndex >= this.partNum) {
            return 0;
        }
        if (this.offset >= this.size) {
            return 0;
        }
        if (this.currentReaderChannel == null) {
            this.currentReaderChannel = this.getReaderChannel(this.getFilePartByIndex(0));

        }
        return this._read(buffer);
    }

    private int _read(ByteBuffer buffer) throws IOException {
        long currentReaderChannelRemainingSize =
            this.currentReaderChannel.size() - this.currentReaderChannel.position();
        long bufferRemainingSize = buffer.remaining();
        if (bufferRemainingSize > currentReaderChannelRemainingSize) {
            this.currentReaderChannel.read(buffer);
            this.currentReaderChannel.close();
            this.partIndex++;
            if (this.partIndex == this.partNum) {
                this.offset = this.offset + currentReaderChannelRemainingSize;
                return 1;
            }
            this.currentReaderChannel = this.getReaderChannel(this.getFilePartByIndex(this.partIndex));
            return this._read(buffer);
        } else {
            int r = this.currentReaderChannel.read(buffer);
            this.offset = this.offset + bufferRemainingSize;
            return r;
        }
    }

    public void close() throws IOException {
        if(this.currentReaderChannel != null){
            this.currentReaderChannel.close();
        }
    }

//    public static void main(String[] aaa) throws Exception {
//        MutilPartFileChannelReader reader = new MutilPartFileChannelReader("C:\\test\\aaa\\2_info.json");
//
//        FileChannelWriter writer = new FileChannelWriter("C:\\test\\aaa\\c", 10 * 1024 * 1024).build();
//
//        ByteBuffer buffer = ByteBuffer.allocate(1024 * 1024 * 2);
//        while (reader.read(buffer) > 0) {
//            // new String(buffer.array())
//            writer.write(buffer.array(), 0, buffer.position());
//            // buffer.array();
//            buffer.flip();
//            buffer.clear();
//        }
//
//        writer.end();
//    }

}
