package com.northpool.commons.javacode.parser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.Name;

import java.util.HashMap;
import java.util.Map;

public class ClassUnit {
    PackageDeclaration packageDec;
    ClassBean mainClass;
    CompilationUnit unit;
    Map<String,ClassBean> subClassMap = new HashMap<>();
    ClassUnit(CompilationUnit unit){
        this.unit = unit;
    }
    
    public PackageDeclaration getPackageDec() {
        return packageDec;
    }

    public ClassBean getMainClass() {
        return mainClass;
    }

    public CompilationUnit getUnit() {
        return unit;
    }

    public Map<String, ClassBean> getSubClassMap() {
        return subClassMap;
    }

    public String getPackageName(){
        if(!unit.getPackageDeclaration().isPresent()){
            return null;
        }else{
            return unit.getPackageDeclaration().get().getNameAsString();
        }
    }
    
    public void setPackageName(String packageName){
        if(!unit.getPackageDeclaration().isPresent()){
            PackageDeclaration packageDeclaration = new PackageDeclaration(new Name(packageName));
            unit.setPackageDeclaration(packageDeclaration);
        }else{
            unit.getPackageDeclaration().get().setName(packageName);
        }
    }
    
    public void setMainClassName(String className){
        //改类名
        this.mainClass.setClassName(className);
        //改引用
    }
    
    public String getCode(){
        return this.unit.toString();
    }
    
}
