package com.northpool.commons.pipeline;

public abstract class AbstractHandler implements Handler {
    
    protected Handler next;
    
    protected Handler previous;
    
    protected Pipeline executePipeline;
    
    void setExecutePipeline(Pipeline executePipeline){
        this.executePipeline = executePipeline;
    }
    
    public void setNext(Handler handler){  
        this.next = handler;
        handler.setPrevious(this);
    } 
    
    public void setPrevious(Handler handler){
        this.previous = handler;
    }
    
    public Handler next(){
        return next;
    }
    
    
    @Override
    public void exceptionOccurr(RuntimeException e) {
        this.executePipeline.exceptionOccurr(e);
    }

}  