package com.northpool.commons.pipeline;

import com.northpool.commons.filechannel.FileChannelWriter;
import com.northpool.commons.filechannel.FileInfo;

import java.io.IOException;

public class FileHandler extends AbstractHandler  implements Handler,AutoCloseable {

	/**
	 * 文件存储路径
	 */
    private String path;
    
    private FileChannelWriter writer;
    
    @SuppressWarnings("resource")
    public FileHandler(String path,Integer buffSize,Boolean md5,Integer splitSize) throws IOException{
        this.path = path;
        if(buffSize == null){
            buffSize = 1024 * 1024;
        }
        if(md5 == null){
            md5 = false;
        }
        this.writer = new FileChannelWriter(this.path, buffSize).md5(md5);
        if(splitSize != null){
            this.writer.setSplitSize(splitSize);
        }
        this.writer.build();
    }

    /* (non-Javadoc)
     * @see com.northpool.commons.pipeline.Handler#end()
     */
    @Override
    public void end() throws Exception {
        // TODO Auto-generated method stub
        
        this.writer.end();
        if(next != null){
            next.end();
        }
      
    }




    /* (non-Javadoc)
     * @see com.northpool.commons.pipeline.Handler#pushData(java.lang.Object)
     * 第二参数buffSize 默认为 1024 * 1024
     */
    @Override
    public <T> void pushData(T data) throws Exception {
        // TODO Auto-generated method stub
        this.writer.write((byte[])data);
        if(next != null){
            next.pushData(data);
        }
    }

    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        writer.close();
    }
    
    public FileInfo getFileInfo(){
        return this.writer.getFileInfo();
    }
   

}
