/**
　 * <p>Title: GunzipHandler.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年10月21日
　 * @version 1.0
*/
package com.northpool.commons.pipeline;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.concurrentli.SequentialQueue;
import com.northpool.commons.concurrent.BlockThreadPool;
import com.northpool.commons.concurrent.DynamicCountDownLatch;
import com.northpool.commons.util.StringUtility;
import com.northpool.commons.util.UString;
import com.northpool.exception.UException;

/**
 * 
 *
 */
public class GunzipHandler extends AbstractHandler implements Handler ,AutoCloseable {
    
    ByteBuffer buffer;
    
   // Lock lock = new ReentrantLock(true);
    
  //  Condition bufferFull = lock.newCondition();
    
    protected Logger logger = LoggerFactory.getLogger(GunzipHandler.class);
    
    private BlockThreadPool _threadPool;
    
    private final SequentialQueue<MiGzBuffer> _decompressedBufferQueue;
        
    private int currentCompressedSize;
    
    private byte[] currentByteBufferZip;
    
    private int currentByteBufferZipOffset = 0;
    
    private byte[] currentHeaderBuffer;
    
    private int currentHeaderBufferOffset = 0;
    //private ByteBuffer
    
    private boolean waitUnzipData = false;
    
    protected AtomicLong finished;
    
    protected AtomicLong finishedSize;
    
    protected AtomicLong apply;
    
    protected AtomicLong applySize;
    
    int toRead;
    
    private long _currentBlock = 0;
    
    DynamicCountDownLatch _count;
    
    AtomicReference<RuntimeException> _exception = new AtomicReference<>(null);
    
    Thread _outputThread;
    
    public GunzipHandler(Integer threads){
        this.buffer = ByteBuffer.allocate(MiGzUtil.DEFAULT_BLOCK_SIZE);
        int outputBufferCount = 2 * threads;
        _decompressedBufferQueue = new SequentialQueue<>(outputBufferCount + 1);
        _threadPool = new BlockThreadPool(threads,100);
        _count = new DynamicCountDownLatch(0);
        if(logger.isDebugEnabled()){
            finished = new AtomicLong(0);
            apply = new AtomicLong(0);
            applySize = new AtomicLong(0);
            finishedSize = new AtomicLong(0);
        }
        _outputThread = new Thread(() -> {
            while(true){
                try {
                    MiGzBuffer buffer = _decompressedBufferQueue.dequeue();
                    if(buffer == null){
                        break;
                    }else{
                       if(logger.isDebugEnabled()){
                           long a = finished.getAndIncrement();
                           long size = finishedSize.addAndGet(buffer.getLength());
                           if(a % 50 == 0){
                               logger.debug(UString.format("解压块 {} 完成 解压大小 {} ,总共解压 {}",a,StringUtility.getDataSize(buffer.getLength()),StringUtility.getDataSize(size)));
                           }
                       }
                       if(this.next != null){
                           this.next.pushData(buffer.getData());
                          
                       }
                       _count.countDown(1);
                    }
                } catch(InterruptedException e){
                    break; 
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    UException.printStackTrace(e);
                    _exception.compareAndSet(null, new RuntimeException(e));
                    break;
                }
            }
        });
        _outputThread.start();
    }
    
    /*private void decompressorThread() throws InterruptedException {
        Inflater inflater = new Inflater(true);
        try {
            decompressorThreadWithInflater(inflater);
        } finally {
            inflater.end();
        }
    }*/
    
    
   
    private static int getIntFromLSBByteArray(byte[] source, int offset) {
        return
            Byte.toUnsignedInt(source[offset])
            | (Byte.toUnsignedInt(source[offset + 1]) << 8)
            | (Byte.toUnsignedInt(source[offset + 2]) << 16)
            | (Byte.toUnsignedInt(source[offset + 3]) << 24);
    }
    
    
    
    private void unzip(byte[] zipBuffer,int compressedSize) throws InterruptedException{
        final byte[] _zipBuffer = zipBuffer;
     //   byte[] zipBuffer = new byte[byteBufferZip.array().length];
      //  System.arraycopy(byteBufferZip.array(), 0, zipBuffer, 0, byteBufferZip.array().length);
        int putativeInflatedSize = getIntFromLSBByteArray(_zipBuffer, compressedSize + 4);
        final byte[] outputBuffer = new byte[putativeInflatedSize];
        final long block = _currentBlock++;
        _count.addNum(1);
        if(logger.isDebugEnabled()){
            long a = apply.getAndIncrement();
            long size = applySize.addAndGet(zipBuffer.length);
            if(a % 50 == 0){
                logger.debug(UString.format("申请解压块 {} ,大小 {} ,总共大小 {}",a,StringUtility.getDataSize(zipBuffer.length),StringUtility.getDataSize(size)));
            }
        }
        this._threadPool.execute(() -> {
            Inflater inflater = new Inflater(true);
            try {
               
                inflater.reset();
                inflater.setInput(_zipBuffer, 0, compressedSize);
                int uncompressedSize = inflater.inflate(outputBuffer);
                _decompressedBufferQueue.enqueue(block, new MiGzBuffer(outputBuffer, uncompressedSize));
            } catch (DataFormatException | InterruptedException e) {
                // TODO Auto-generated catch block
                _exception.compareAndSet(null, new RuntimeException(e));
                
            } finally {
                inflater.end();
               
            }
        });
       // _decompressedBufferQueue.dequeue()
    }
    
    
    private boolean _pushToUnzip() throws InterruptedException{
        if(!this.waitUnzipData){
            if(!this.buffer.hasRemaining()){
                return false;
            }
            //如果BUFFER里面连头文件的20B都不够
            if(this.currentHeaderBufferOffset == 0){
                this.currentHeaderBuffer = new byte[MiGzUtil.GZIP_HEADER_SIZE];
                if(this.buffer.remaining() >= MiGzUtil.GZIP_HEADER_SIZE){
                    this.buffer.get(currentHeaderBuffer);
                }else{
                    int length =  this.buffer.remaining();
                    this.buffer.get(this.currentHeaderBuffer, this.currentHeaderBufferOffset,length);
                    this.currentHeaderBufferOffset = length;
                    return false;
                }
            }else{
                this.buffer.get(this.currentHeaderBuffer, this.currentHeaderBufferOffset, MiGzUtil.GZIP_HEADER_SIZE - this.currentHeaderBufferOffset);
                this.currentHeaderBufferOffset = 0;
            }
            this.waitUnzipData = true;
            this.currentCompressedSize = getIntFromLSBByteArray(currentHeaderBuffer, currentHeaderBuffer.length - 4);
            int toRead = this.currentCompressedSize + MiGzUtil.GZIP_FOOTER_SIZE;
            this.currentByteBufferZip = new byte[toRead];
            if((this.buffer.limit() - this.buffer.position()) >= toRead){
                System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, 0, toRead);
                this.buffer.position(this.buffer.position() + toRead);
                this.unzip(this.currentByteBufferZip,this.currentCompressedSize);
                this.waitUnzipData = false;
                return true;
            }else{
                System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, 0, this.buffer.limit() - this.buffer.position());
                this.currentByteBufferZipOffset = this.buffer.limit() - this.buffer.position();
               // this.currentByteBufferZip.put(this.buffer.array(),this.buffer.position(),this.buffer.limit());
                return false;
            }
        }else{
            int toRead = this.currentCompressedSize + MiGzUtil.GZIP_FOOTER_SIZE;
            if(this.currentByteBufferZipOffset + this.buffer.limit() - this.buffer.position() >= toRead){
                System.arraycopy(this.buffer.array(),this.buffer.position() , this.currentByteBufferZip, this.currentByteBufferZipOffset, toRead - this.currentByteBufferZipOffset);
                //this.currentByteBufferZip.put(this.buffer.array(),this.buffer.position(),toRead);
                this.buffer.position(this.buffer.position() + toRead - this.currentByteBufferZipOffset);
                this.unzip(this.currentByteBufferZip,this.currentCompressedSize);
                this.waitUnzipData = false;
                return true;
            }else{
                System.arraycopy(this.buffer.array(), this.buffer.position() , this.currentByteBufferZip, this.currentByteBufferZipOffset, this.buffer.limit() - this.buffer.position());
                //this.currentByteBufferZip.put(this.buffer.array(),this.buffer.position(),this.buffer.limit());
                return false;
            }
        }
        
    }
    
    private synchronized void _putDate(byte[] data,int offset,int length) throws Exception {
      //  byte[] zipBuffer;
        long bufferRemainingSize = this.buffer.remaining();
        if((length - offset) >= bufferRemainingSize){
            this.buffer.put(data, offset, (int)bufferRemainingSize);
            this.buffer.flip();
            while(this._pushToUnzip()){
                
            }
            this.buffer.compact();
            this.buffer.clear();
            offset = offset + (int)bufferRemainingSize;
            this._putDate(data, offset, length);
        }else{
            if(offset == length){
                return;
            }
            this.buffer.put(data,offset,length - offset);
        }
    }
    
    
    @Override
    public  <T> void pushData(T t) throws Exception {
        //lock.lockInterruptibly();
        byte[] data = (byte[])t;
        /*if(data.length < MiGzUtil.GZIP_HEADER_SIZE){
            
        }else{
            
        }*/
      //  ByteBuffer byteBufferZip = null;
       // Integer compressedSize = -1;
        this._putDate(data, 0, data.length);
        
        /*if(!this.waitUnzipData){
            byte[] currentHeaderBuffer = new byte[MiGzUtil.GZIP_HEADER_SIZE];
            System.arraycopy(data, srcPos, currentHeaderBuffer, destPos, length);
        }*/
        
        
        
        
      //  this._putDate(data, 0, data.length);
      //  long bufferRemainingSize = this.buffer.remaining();
     /*   if(data.length > bufferRemainingSize){
            this._putDate(data, 0, (int)bufferRemainingSize);
        }else{
            this.buffer.put(data);
        }*/
        
        //long bufferRemainingSize = this.buffer.remaining();
        /*if(data.length > bufferRemainingSize){
            this.buffer.put(data, 0, (int)bufferRemainingSize);
            this.unzip();    
                
           
            //this.buffer.clear();
            //this.buffer.put(data, (int)bufferRemainingSize,this.buffer.remaining());
        }else{
            this.buffer.put(data);
        }*/
        
      /*  if(!this.waitUnzipData){
            if(this.buffer.position() < MiGzUtil.GZIP_HEADER_SIZE){
                //等待下次传输ZIP头
                return;
            }else{
                //获得ZIP头
                this.buffer.flip();
                this.buffer.get(this.currentHeaderBuffer);
                int compressedSize = getIntFromLSBByteArray(this.currentHeaderBuffer, this.currentHeaderBuffer.length - 4);
                this.toRead = compressedSize + MiGzUtil.GZIP_FOOTER_SIZE;
                this.waitUnzipData = true;
                
            }
            
            
            //int compressedSize = getIntFromLSBByteArray(this.currentHeaderBuffer, this.currentHeaderBuffer.length - 4);
        }*/
        
        
       /* if(data.length > bufferRemainingSize){
            this.buffer.put(data, 0, (int)bufferRemainingSize);
            this.sendDataToNext();
            this.buffer.flip();
            this.buffer.clear();
            this.buffer.put(data, (int)bufferRemainingSize, (data.length - (int)bufferRemainingSize));
        }else{
            this.buffer.put(data);
        }*/
       
    }
    
    /*private void sendDataToNext() throws Exception{
        MiGzBuffer buffer;
        while ((buffer = mzis.readBuffer()) != null) {
            this.next.pushData(buffer.getData());
        }
    }*/

   
    @Override
    public void end() throws Exception {
        // TODO Auto-generated method stub
      //  this.sendDataToNext();
        
        this.buffer.flip();
        while(this._pushToUnzip()){
            
        }
        _count.await();
        logger.debug(UString.format("解压缩完成,一共解压 {} 块，大小 {} ，解压后大小 {}", finished.get(),StringUtility.getDataSize(this.applySize.get()),StringUtility.getDataSize(this.finishedSize.get())));
        if(this.next != null){
            this.next.end();
        }
        
        _threadPool.shutdown();
        try{
            _outputThread.interrupt();
        }finally{
            
        }
    }

    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        _threadPool.shutdown();
        try{
            _outputThread.interrupt();
        }finally{
            
        }
    }
    
   /* class BytesInputStream extends InputStream{

        GunzipHandler handler;
        
        BytesInputStream(GunzipHandler handler){
            this.handler = handler;
        }
        
        
        @Override
        public int read() throws IOException {
            // TODO Auto-generated method stub
            return 0;
        }
        
        public int read(byte[] b, int off, int len) throws IOException{
            if(off > handler.buffer.position()){
                return 0;
            }else{
                try{
                    handler.buffer.get(b, off, len);
                }catch(Exception e){
                    e.printStackTrace();
                }
                return 1;
            }
        }
    }*/

}
