/**
　 * <p>Title: GZipHandler.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年9月9日
　 * @version 1.0
*/
package com.northpool.commons.pipeline;

import java.io.IOException;
import java.io.OutputStream;

import com.linkedin.migz.MiGzOutputStream;

/**
 * 
 *
 */
public class GzipHandler extends AbstractHandler implements Handler, AutoCloseable  {
	/**
	 * 缓冲区大小
	 */
    private Integer blockSize;
    /**
     * 压缩输出流
     */
    private MiGzOutputStream zipOutputStream;
    /**
     * 字节输出流
     */
    private BytesOutputStream outputStream;
   /* public GZipHandler(){
        
    }*/
    
    /**
     * 
     * @param threadCount 线程数
     * @param blockSize 缓冲区大小
     * @param compressionLevel 压缩等级，共9级，1~9
     */
    public GzipHandler(Integer threadCount,Integer blockSize,Integer compressionLevel){
        this.blockSize = blockSize;
        this.outputStream = new BytesOutputStream(this);
        this.zipOutputStream = new MiGzOutputStream(outputStream, threadCount, blockSize).setCompressionLevel(compressionLevel);
       
    }

    
//    public void channelSend(HandlerContext<byte[]> next, byte[] msg) {
//        // TODO Auto-generated method stub
//        
//        try {
//            this.zipOutputStream.write(msg);
//            this.zipOutputStream.flush();
//            byte[] zipByte = this.byteArrayOutputStream.toByteArray();
//            next.doWork(zipByte);
//            this.byteArrayOutputStream.reset();
//        } catch (IOException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        
//    }
//
//    @Override
//    public void end(HandlerContext<byte[]> next) {
//        // TODO Auto-generated method stub
//        
//    }

    /* (non-Javadoc)
     * @see com.northpool.commons.pipeline.Handler#pushData(java.lang.Object)
     */
    
   /* private  void goNext() throws Exception{
        System.out.println("--------------------flush");
        //10485760
        //10485662
        this.currentOffset = 0;
      ///  this.zipOutputStream.flush();
        if(this.next != null){
            this.next.pushData(this.byteArrayOutputStream.toByteArray());
            this.byteArrayOutputStream.reset();
        }
    }*/
    
    @Override
    public synchronized <T> void pushData(T t) throws Exception {
        // TODO Auto-generated method stub
        byte[] data = (byte[])t;
        try{
            this.zipOutputStream.write(data);
        }catch(Exception e){
            e.printStackTrace();
        }
       /* int bytesLength = data.length;
        if(this.currentOffset + bytesLength > this.blockSize){
            int fristPart = this.blockSize - this.currentOffset;
            if(fristPart == 0){
                this.goNext();
                this.zipOutputStream.write(data);
            }else{
                this.zipOutputStream.write(data, 0, fristPart);
                this.goNext();
                this.zipOutputStream.write(data, fristPart, bytesLength - fristPart);
            }
        }else{
            this.zipOutputStream.write(data);
        }
        this.currentOffset = this.currentOffset + bytesLength;*/
    }

    
    @Override
    public synchronized void end() throws Exception {
        // TODO Auto-generated method stub
        this.outputStream.flush();
        
        this.zipOutputStream.close();
        if(this.next != null){
            this.next.end();
        }
    }
    
    class BytesOutputStream extends OutputStream {

        GzipHandler handler;
        
        BytesOutputStream(GzipHandler handler){
            this.handler = handler;
         //   buffer = new byte[blockSize];
        }
        
        @Override
        public void write(int b) throws IOException {
            // TODO Auto-generated method stub
         //   buffer[count] = (byte) b;
        //    count += 1;
        }
        
        public synchronized void flush() throws IOException {
           /* if(this.next != null){
                try {
                    byte[] out = new  byte[count];
                    System.arraycopy(buffer, 0, out, 0, count);
                    this.next.pushData(buffer);
                    count = 0;
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                   throw new RuntimeException(e);
                }
            }*/
        }
        
        public synchronized void write(byte[] b, int off, int len) throws IOException{
            byte[] out = new  byte[len];
            System.arraycopy(b, 0, out, 0, len);
            try {
                if(this.handler.next != null){
                    this.handler.next.pushData(out);
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
               throw new RuntimeException(e);
            }
        }
        
    }

    /* (non-Javadoc)
     * @see java.lang.AutoCloseable#close()
     */
    @Override
    public void close() throws Exception {
        // TODO Auto-generated method stub
        this.zipOutputStream.close();
        
    }
    
    
}
