package com.northpool.commons.reflect;

import java.lang.reflect.Method;

import com.northpool.commons.reflect.Invoker;

public interface InvokerManager {
    
    
    

	/**
	 * 快捷调用公共方法（性能较差）
	 * 
	 * @param host
	 *            宿主对象
	 * @param name
	 *            方法名
	 * @param args
	 *            方法参数
	 * @return 执行结果
	 * @throws NoSuchMethodException
	 *             如果没有相应的方法
	 */
	public Object invokePublic(Object host, String name, Object... args) throws NoSuchMethodException;
	
	
	/**
	 * 根据传入的方法创建快速调用器。 
	 * 
	 * @param method
	 *            方法对象
	 * @return 调用器
	 */
	public Invoker newInvoker(Method method);
	
	/**
	 * 快速动态调用宿主方法。 如果指定了方法名，则执行方法时只会调用指定了的方法。 <br/>
	 * 如果没有指定方法名，则调用宿主中对应接口类的同名方法。
	 * 
	 * @param superClass
	 *            接口类
	 * @param hostClass
	 *            宿主类
	 * @param methodName
	 *            宿主方法名（可选）
	 * @param hostMethodParameterTypes
	 *            宿主方法参数（可选）
	 * @param hostMethodReturnType
	 *            宿主方法返回类型（可选）
	 * @return 代理实例
	 */
	public <T> T newInvoker(Class<T> superClass, Class<?> hostClass,
			String methodName, Class<?>[] hostMethodParameterTypes,
			Class<?> hostMethodReturnType);
	
	/**
	 * 快速动态调用宿主方法。 如果指定了方法名，则执行方法时只会调用指定了的方法。 <br/>
	 * 如果没有指定方法名，则调用宿主中对应接口类的同名方法。
	 * 
	 * @param superClass
	 *            接口类
	 * @param hostClass
	 *            宿主类
	 * @param methodName
	 *            方法名（可选）
	 * @return 代理实例
	 */
	public <T> T newInvoker(Class<T> superClass, Class<?> hostClass,
			String methodName);
	
	/**
	 * 快速动态调用宿主方法。调用宿主中对应接口类的同名方法。
	 * 
	 * @param superClass
	 *            接口类
	 * @param hostClass
	 *            宿主类
	 * @return 代理实例
	 */
	public <T> T newInvoker(Class<T> superClass, Class<?> hostClass);
}
