package com.northpool.commons.reflect;

import com.northpool.commons.reflect.beanHolder.BeanHolderManagerImpl;
import com.northpool.commons.reflect.functionHolder.FunctionHolderManagerImpl;
import com.northpool.commons.reflect.invoker.JavassistInvokerManagerImpl;
import com.northpool.exception.CommonException;

public class Reflect {
	
	
	private static InvokerManager _InvokerManager = new JavassistInvokerManagerImpl();

	private static BeanHolderManager _BeanHolderManager = new BeanHolderManagerImpl();
	
	private static FunctionHolderManager _functionHolderManager = new FunctionHolderManagerImpl();;
	
	static ClassLoader CLASS_LOADER = null;
	
	public static void setClassLoader(ClassLoader classloader){
	    CLASS_LOADER = classloader;
	}
	
	public static ClassLoader getClassLoader(){
	    if(CLASS_LOADER == null){
	        return Thread.currentThread().getContextClassLoader();
	    }
	    return CLASS_LOADER;
	    
	}
	
	
	/**
	 * 获得InvokerManager
	 * @return
	 */
	public static InvokerManager getInvokerManager(){
		return _InvokerManager;
	}
	
	/**
	 * 获得BeanHolderManager
	 * @return
	 */
	
	public static BeanHolderManager getBeanHolderManager(){
		return _BeanHolderManager;
	}
	
	/**
	 * 获得FunctionHolderManager
	 * @return
	 */
	public static FunctionHolderManager getFunctionHolderManager(){
		return _functionHolderManager;
	}
	
	
	
	
	
	
	
	
	
	/***
	 *  获得实例
	 * @Title:
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param clazzName
	 * @return
	 * @throws CommonException   设定参数 
	 * @return Object    返回类型
	 * @throws ReflectFindException 
	 * @Description: TODO 得到实例
	 */
	
	public static <T> T getObjectInstance(Class<T> clazz) throws ReflectFindException{
		try {
			T o =  clazz.newInstance();
			return  o;
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new ReflectFindException(e.getMessage());
			
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new ReflectFindException(e.getMessage());
		}	
	}
	
	
	/***
	 * 获得静态函数实例
	 * @Title: 
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param clazzName
	 * @return
	 * @throws CommonException   设定参数 
	 * @return Object    返回类型
	 * @throws ReflectFindException 
	 * @Description: TODO 得到静态实例
	 * 速度缓慢，大批量使用时应做缓存 10万 131
	 */
	public static Class<?> getObjectClass(String clazzName) throws ReflectFindException {
		Class<?> o;
		try {
			o = Class.forName(clazzName,true,getClassLoader());
			return o;
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new ReflectFindException(e.getMessage());
		}
		
	}
	
	
}
