package com.northpool.commons.reflect.beanHolder;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

import com.northpool.commons.reflect.Bean;
import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.FieldHolder;
import com.northpool.commons.reflect.beanHolder.FieldHoder.FieldHolderImpl;

public abstract class AbstractBeanHolderImpl<T> implements BeanHolder<T> {
	
	/**
	 * 对应的类
	 */
	protected Class<T> clazz;
	
	
	protected BeanInfo beanInfo;
	
	
	protected HashMap<String,FieldHolder> fieldHolderMap = new HashMap<String,FieldHolder>();
	
	
	protected HashMap<String,FieldHolder> privateFieldHolderMap =  new HashMap<String,FieldHolder>();
	
	
	public AbstractBeanHolderImpl(Class<T> clazz){
		this.clazz = clazz;
	
		try {
			this.beanInfo = Introspector.getBeanInfo(clazz);
		} catch (IntrospectionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new BeanNotFindException(clazz.getName());
		}
		
		//开始遍历beanInfo
		PropertyDescriptor[] props = this.beanInfo.getPropertyDescriptors();
		
		for (PropertyDescriptor propertyDescriptor : props) {
			String propertyName = propertyDescriptor.getName();
		
			/**
			 * 去掉class
			 */
			if(propertyName.equalsIgnoreCase("class")){
				continue;
			}
		
			
			FieldHolder fieldHolder = this.createFieldHolder(propertyDescriptor);
			//if(!fieldHolder.isAbstract()){
			fieldHolderMap.put(propertyName, fieldHolder);
			//}
		}
		
		this.addPublicFields(fieldHolderMap);
		
		//
		this.privateFieldHolderMap(privateFieldHolderMap);
		
		
	}
	
	
	protected void privateFieldHolderMap(HashMap<String,FieldHolder> fieldHolderMap){
	    Field[] fieldArray = this.clazz.getDeclaredFields();
	    for(Field field : fieldArray){
            if(!Modifier.isStatic(field.getModifiers())){
                String name = field.getName();
                if(fieldHolderMap.get(name) == null){
                    FieldHolder fieldHolder = this.createFieldHolder(field);
                    fieldHolderMap.put(name, fieldHolder);
                }
            }
        }
	    Class<?> superClass = this.clazz.getSuperclass();
	    if(superClass != null){
	        BeanHolderImpl beanHolderImpl = (BeanHolderImpl)Bean.getBeanHolder(superClass);
	        this.privateFieldHolderMap.putAll(beanHolderImpl.privateFieldHolderMap);
	    }
	}
	
	
	protected void addPublicFields(HashMap<String,FieldHolder> fieldHolderMap){
	    Field[] fieldArray = this.clazz.getFields();
	    for(Field field : fieldArray){
	        if(!Modifier.isStatic(field.getModifiers())){
	            String name = field.getName();
	            if(fieldHolderMap.get(name) == null){
	                FieldHolder fieldHolder = this.createFieldHolder(field);
	                fieldHolderMap.put(name, fieldHolder);
	            }
	        }
	    }
	    
	}
	
	
	/**
	 * 创建FieldHolder
	 * @param propertyDescriptor
	 * @return
	 */
	protected FieldHolder createFieldHolder(PropertyDescriptor propertyDescriptor){
		return new FieldHolderImpl<T>(propertyDescriptor,this.clazz,this);
	}
	
	protected FieldHolder createFieldHolder(Field field){
        return new FieldHolderImpl<T>(field,this.clazz,this);
    }
	
	
	
	/*public Field getFieldByName(String fieldName,Boolean findParent){
		Field f = null;
		try {
			 f = clazz.getDeclaredField(fieldName);
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} catch (NoSuchFieldException e) {
			 f = BeanTool.getFieldByName(clazz.getSuperclass(), fieldName);
			
		}
		return f;
		
	}*/
	
	
	
	protected Field getFieldByName(@SuppressWarnings("rawtypes") Class clazz,String fieldName,Boolean findParent){
		Field f = null;
		try {
			 f = clazz.getDeclaredField(fieldName);
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw e;
		} catch (NoSuchFieldException e) {
			
			if(findParent){
				f = this.getFieldByName(clazz.getSuperclass(), fieldName,findParent);
			}
		}
		return f;
	}
	
	
	
	@Override
	public FieldHolder getFieldHolder(String fieldName){
		return this.getFieldMap().get(fieldName);
	}
	

	@Override
	public Map<String,FieldHolder> getFieldMap() {
		// TODO Auto-generated method stub
		return (Map<String,FieldHolder>) this.fieldHolderMap;
	}
	@Override
	public T getNewInstance() {
		// TODO Auto-generated method stub
		try {
			clazz.newInstance();
			return clazz.newInstance();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		return null;
	}
	
	/*public T getNewInstance(Object... parameters) {
	    
	    clazz.getConstructor(parameterTypes)
	}*/
	public Map<String,FieldHolder> getPrivateFieldMap(){
	    return this.privateFieldHolderMap;
	}
	
	public static void main(String [] aaa){
	    BeanHolder BeanHolder = new BeanHolderImpl(Exception.class);
	    Map<String,FieldHolder> m = BeanHolder.getPrivateFieldMap();
	    System.out.print(m);
	    
	}
	
	
}
