package com.northpool.commons.reflect.beanHolder;



import java.util.HashMap;

import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.BeanHolderManager;

/**
 * 储存bean信息
 * 
 *
 */
public class BeanHolderManagerImpl implements BeanHolderManager {
	/**
	 * 调用器池
	 */
	@SuppressWarnings("rawtypes")
	private static HashMap<String,BeanHolder> BEAN_MAP = new HashMap<String,BeanHolder>();
	

	
	@Override
	public <T> BeanHolder<T> createBeanHolder(Class<T> clazz) {
		
		BeanHolder<T> BeanHolder = new BeanHolderImpl<T>(clazz);
		
		
		return BeanHolder;
	}
	@Override
	@SuppressWarnings("unchecked")
	public <T> BeanHolder<T> getBeanHolder(Class<T> clazz) {
		
		
		
		
		
		return BEAN_MAP.get(clazz);
	}
	
	/*public void registerBeanHolder(Class<? extends BaseObject> clazz,
			BeanHolder<? extends BaseObject> beanHolder) {
		
		BeanHolder<? extends BaseObject> holder = (BeanHolder<? extends BaseObject>) BEAN_MAP.get(clazz);
		
		if(holder != null){
			return;
		}
		
		synchronized(BeanHolderManagerImpl.class){
			holder = this.getBeanHolder(clazz);
			if(holder == null){
				FastHashMap tmp = new FastHashMap(BEAN_MAP);
				tmp.put(clazz, beanHolder);
				tmp.setFast(true);
				BEAN_MAP = tmp;
			}
		}
		
	}*/
	@Override
	@SuppressWarnings("unchecked")
	public  <T> void registerBeanHolder(Class<T> clazz,BeanHolder<T> beanHolder,Boolean over) {
		synchronized(this){
			BeanHolder<T> holder =  BEAN_MAP.get(clazz);
			
			if(holder != null && over == false ){
				return;
			}
			
			@SuppressWarnings("rawtypes")
			HashMap tmp = new HashMap(BEAN_MAP);
			tmp.put(clazz, beanHolder);
			BEAN_MAP = tmp;
		}

	}
	
	
	
	
	
}
