package com.northpool.commons.reflect.functionHolder;

import java.lang.reflect.Method;

import com.northpool.commons.reflect.FunctionHolder;




public abstract class AbstractFunctionHolderImpl implements FunctionHolder {
	
	
	
	private int hashCode;
	
	private Method invoker;
	
	
	public AbstractFunctionHolderImpl(int hashCode,Class clazz,String name,Class[] argsClass){
		this.hashCode = hashCode;
		
		Method method = null;
		try {
			method = clazz.getMethod(name, argsClass);
			
			
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			
			throw new FunctionNotFindException(e.getMessage());
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new FunctionNotFindException(e.getMessage());
		}
		method.setAccessible(true);
		
		
		this.invoker = method;
		
	}
	
	@Override
	public Method getInvoker() {
		// TODO Auto-generated method stub
		return invoker;
	}
	
	@Override
	public int getHashCode(){
		return hashCode;
	}

}
