package com.northpool.commons.util;

import java.nio.ByteOrder;

public class BuilderCreator {
	private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();
	public static DoubleBuilder createDouble(){
		if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
			
			return new DoubleBuilderL();
		}else{
			return null;
		}
	}
	
	public static DoubleBuilder createDouble(double[] arr){
		if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
			return new DoubleBuilderL(arr);
		}else{
			return null;
		}
	}
	
	public static DoubleBuilder createDouble(int size){
		if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
			return new DoubleBuilderL(size);
		}else{
			return null;
		}
	}
	
	public static FStringBuilder createString(){
		if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
			 
			return (FStringBuilder) new StringBuilderL();
		}else{
			return null;
		}
	}
	
	public static FStringBuilder createString(String str){
		if(nativeOrder == ByteOrder.LITTLE_ENDIAN){
			return (FStringBuilder) new StringBuilderL(str);
		}else{
			return null;
		}
	}
	
}
