/**
　 * <p>Title: Cmd.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年3月16日
　 * @version 1.0
*/
package com.northpool.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

/**
 * 
 *
 */
public class CmdWindows {
    
    public static String executeCMD(String cmdStr) throws Exception {
        
        Runtime run = Runtime.getRuntime();
        try {
            Process process = run.exec("cmd.exe /c " + cmdStr);
            InputStream in = process.getInputStream();
            LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream(),"GBK"));
            StringBuffer sb = new StringBuffer();  
            String line;  
            while ((line = br.readLine()) != null) {  
                sb.append(line).append("\n");  
            }  
            process.waitFor();
            return sb.toString();
        } catch (Exception e) {
            throw e;
        }
 
    }
 
    /**
     * 将日志输出到文件
     * @param cmmands    命令数组adb logcat -v time > d:/adb.log { "adb",
     *                   "logcat","-v","time"}
     * @param logToFile  保存的文件
     * @param dirTodoCMD 在此目录下执行
     * @return
     * @throws Exception 
     */
    public static String executeCMDFile(String[] cmmands, String logToFile, String dirTodoCMD) throws Exception {
 
        try {
            ProcessBuilder builder = new ProcessBuilder(cmmands);
            if (dirTodoCMD != null)
                builder.directory(new File(dirTodoCMD));
            builder.redirectErrorStream(true);
            builder.redirectOutput(new File(logToFile));
            Process process = builder.start();
            process.waitFor();
            // 得到命令执行后的结果

            InputStream is = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is, "GBK"));
            String line = null;
            StringBuffer sbBuffer = new StringBuffer();
            while ((line = buffer.readLine()) != null) {
                sbBuffer.append(line);
            }
 
            is.close();
            return sbBuffer.toString();
        } catch (Exception e) {
            throw e;
        }
    }
    
    /**
     * Windows执行本地命令行
     * 测试ok
     * @param cmd
     * @param workpath  在此目录下执行
     * @return
     * @throws Exception 
     */
     public static String executeLocalCmd(String cmd, File workpath) throws Exception {  
         try {  
             String[] cmdA = { "cmd.exe", "/c", cmd };  
             Process process = null;
             if(workpath==null){
                 process = Runtime.getRuntime().exec(cmdA);  
             }else{
                 process = Runtime.getRuntime().exec(cmdA, null, workpath);  
             }
//             LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream()));
             LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream(),"GBK"));
             StringBuffer sb = new StringBuffer();  
             String line;  
             while ((line = br.readLine()) != null) {  
                 sb.append(line).append("\n");  
             }  
             return sb.toString();  
         } catch (Exception e) {
             throw e;
         }  
     }  

}
