package com.northpool.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

/**
 * @ClassName：DateUtility @author： 许明杰 @date： 2011-7-4 @Description： TODO
 */

public class DateUtility {
    private static final long ONE_DAY = 86400000L;

    // 用来全局控制上一周，本周，下一周的周数变化
    private static int weeks = 0;

    /**
     * @Description: TODO(得到当前日期)
     * @Title: getCurrentDate
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(得到当前时间)
     * @Title: getCurrentTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前秒数)
     * @Title: getCurrentm
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentm() {
        SimpleDateFormat df = new SimpleDateFormat("ss");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前时间)
     * @Title: getCurrentHhMmSs
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentHhMmSs() {

        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前年)
     * @Title: getCurrentYear
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentYear() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得传入时间的年份)
     * @Title: getYear
     * @author: 许明杰
     * @date: 2013-8-29
     * @param d
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getYear(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String s = df.format(d);
        return s;
    }

    /**
     * @Description: TODO(获得当前月)
     * @Title: getCurrentMonth
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentMonth() {
        SimpleDateFormat df = new SimpleDateFormat("MM");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前周的最后一天)
     * @Title: getDayInWeek
     * @author: 许明杰
     * @date: 2013-8-29
     * @param sDate
     * @return 设定参数
     * @return String 返回类型
     * 
     */
            public static String getDayInWeek(String sDate) {
        Date date = strToDate(sDate);
        SimpleDateFormat df = new SimpleDateFormat("EEE");
        String s = df.format(date);
        return s;
    }

    /**
     * @Description: TODO(将yyyy-MM-dd的STR转成日期)
     * @Title: strToDate
     * @author: 许明杰
     * @date: 2013-8-29
     * @param str
     * @return 设定参数
     * @return Date 返回类型
     * 
     */
    public static Date strToDate(String str) {
        Date date = null;
        if (str != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date = df.parse(str);
            } catch (ParseException e) {
                // log.error("DateParse Error!");
            }
        }
        return date;
    }

    /**
     * @Description: TODO(将yyyy-MM-dd HH:mm:ss的STR转成时间)
     * @Title: strToDateTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param str
     * @return 设定参数
     * @return Date 返回类型
     * 
     */
    public static Date strToDateTime(String str) {
        Date date = null;
        if (str != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = df.parse(str);
            } catch (ParseException e) {
                // log.error("DateParse Error!");
            }
        }
        return date;
    }

    /**
     * @Description: TODO(获得当前年月日时分秒，如20130829112304)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getDAT() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前年月日时分秒，如2013-08-29 11:23:04)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateTimeToStr(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(获得年月日，如2013-08-29)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToStr(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(获得年月日，如2013-08-29)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToYearMonthDay(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(获得年月，如2013-08)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToYearMonth(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建日期年月日目录路径)
     * @Title: dateToPathYearMonthDay
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToPathYearMonthDay(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy年\\MM月\\dd日");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建日期年月日目录路径 以逗号分割)
     * @Title: dateToPathYearMonthDaySplit
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToPathYearMonthDaySplit(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy年,MM月,dd日");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建日期年月目录路径)
     * @Title: dateToPathYearMonth
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToPathYearMonth(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy年\\MM月");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建日期年月目录路径 以逗号分割)
     * @Title: dateToPathYearMonthSplit
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToPathYearMonthSplit(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy年,MM月");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建日期年目录路径)
     * @Title: dateToPathYearMonthSplit
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToPathYear(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy年");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    /**
     * @Description: TODO(创建年月日 如2013 08 29)
     * @Title: dateToPathYearMonthSplit
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String dateToStrCh(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd ");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static Date add(Date date, int i) {
        date = new Date(date.getTime() + i * ONE_DAY);
        return date;
    }

    public static Date add(Date date) {
        return add(date, 1);
    }

    public static Date sub(Date date) {
        return add(date, -1);
    }

    public static String getBeforeDate() {
        Date date = DateUtility.sub(new Date());
        return DateUtility.dateToStr(date);

    }

    /**
     * @Description: TODO(获得当前年月日时分秒，如2013-08-29 11:23:04)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentDateTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s = df.format(new Date());
        return s;
    }

    /**
     * @Description: TODO(获得当前年月日星期，如2013 08 29 星期)
     * @Title: getDAT
     * @author: 许明杰
     * @date: 2013-8-29
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getCurrentDateWeek() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd EEE");
        String s = df.format(new Date());
        return s;

    }

    public static String getCurrentDateWeekEn() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy ", new Locale("en"));
        String s = df.format(new Date());
        return s;

    }

    public static int compareMonth(String startYear, String startMonth, String endYear, String endMonth) {
        return (Integer.parseInt(endYear) - Integer.parseInt(startYear)) * 12
            + (Integer.parseInt(endMonth) - Integer.parseInt(startMonth));

    }

    /**
     * 
     * @param sDate
     * @return
     */
    public static String getYearMonth(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("yyMM");
            s = df.format(date1);
        } catch (ParseException e) {
            return s;
        }
        return s;
    }

    /**
     * 
     * @param date
     * @return
     */
    public static String getYearMonth(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyMM");
        String s = null;

        s = df.format(date);

        return s;

    }

    public static String getMonthDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MM dd ");
        String s = null;

        s = df.format(date);

        return s;

    }

    public static String getYearMonthDay(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("yyMMdd");
            s = df.format(date1);
        } catch (ParseException e) {
            return s;
        }
        return s;
    }

    /**
     * @Description: TODO(获得开始查询时间 如 2013-08-29 00:00:00)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getStartQueryTime(String date) {
        return DateUtility.dateToStr(DateUtility.strToDate(date)) + " 00:00:00";
    }

    /**
     * @Description: TODO(获得结束查询时间 如 2013-08-29 23:59:59)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getEndQueryTime(String date) {
        return DateUtility.dateToStr(DateUtility.strToDate(date)) + " 23:59:59";
    }

    /**
     * 
     * @param sDate
     * @return
     */
    public static String getMonth(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("MM");
            s = df.format(date1);
        } catch (ParseException e) {
            return s;
        }
        return s;

    }

    /**
     * 
     * @param sDate1
     * @param sDate2
     * @return
     */
    public static int compareDate(String sDate1, String sDate2) {

        Date date1 = null;
        Date date2 = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

        try {
            date1 = dateFormat.parse(sDate1);
            date2 = dateFormat.parse(sDate2);
        } catch (ParseException e) {

        }

        long dif = 0;
        if (date2.after(date1)) {
            dif = (date2.getTime() - date1.getTime()) / 1000 / 60 / 60 / 24;
        } else {
            dif = (date1.getTime() - date2.getTime()) / 1000 / 60 / 60 / 24;
        }
        return (int)dif;
    }

    public static int getDate(String sDate, String sTag) {
        int iSecondMinusPos = sDate.lastIndexOf('-');
        if (sTag.equalsIgnoreCase("y")) {
            return Integer.parseInt(sDate.substring(0, 4));
        } else if (sTag.equalsIgnoreCase("m")) {
            return Integer.parseInt(sDate.substring(5, iSecondMinusPos));
        } else {
            return Integer.parseInt(sDate.substring(iSecondMinusPos + 1));
        }
    }

    public static int getDayOfWeek() {

        Calendar toDay = Calendar.getInstance();

        toDay.setFirstDayOfWeek(Calendar.MONDAY);

        int ret = toDay.get(Calendar.DAY_OF_WEEK) - 1;

        if (ret == 0) {
            ret = 7;
        }

        return ret;
    }

    public static String getFirstDayOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDate = ca.getTime();
        ca.add(Calendar.MONTH, 1);
        ca.add(Calendar.DAY_OF_MONTH, -1);
        Date lastDate = ca.getTime();

        return dateToStr(firstDate);

    }

    public static String getFirstDayOfMonth(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDate = ca.getTime();
        ca.add(Calendar.MONTH, 1);
        ca.add(Calendar.DAY_OF_MONTH, -1);
        Date lastDate = ca.getTime();

        return dateToStr(firstDate);

    }

    public static String getLastDayOfMonth(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDate = ca.getTime();
        ca.add(Calendar.MONTH, 1);
        ca.add(Calendar.DAY_OF_MONTH, -1);
        Date lastDate = ca.getTime();
        return dateToStr(lastDate);
    }

    public static String getLastDayOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDate = ca.getTime();
        ca.add(Calendar.MONTH, 1);
        ca.add(Calendar.DAY_OF_MONTH, -1);
        Date lastDate = ca.getTime();
        return dateToStr(lastDate);
    }

    public static void main(String[] args) {
        System.out.println(DateUtility.getCurrentTime());

    }

    /**
     * @Description: TODO(获得昨天)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String yesterday() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(Calendar.DATE, -1);
        param.append(String.valueOf(calendar.get(Calendar.YEAR))).append("-")
            .append(String.valueOf(calendar.get(Calendar.MONTH) + 1)).append("-")
            .append(String.valueOf(calendar.get(Calendar.DATE)));
        return param.toString();
    }

    /**
     * @Description: TODO(获得最近7天)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String lately7Day() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(Calendar.DATE, -7);
        param.append(String.valueOf(calendar.get(Calendar.YEAR))).append("-")
            .append(String.valueOf(calendar.get(Calendar.MONTH) + 1)).append("-")
            .append(String.valueOf(calendar.get(Calendar.DATE)));
        return param.toString() + "," + dateToYearMonthDay(new Date());
    }

    /**
     * @Description: TODO(获得最近30天)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String lately30Day() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(Calendar.DATE, -30);
        /*param.append(String.valueOf(calendar.get(Calendar.YEAR))).append("-").append(
        		String.valueOf(calendar.get(Calendar.MONTH) + 1)).append("-").append(String.valueOf(calendar.get(Calendar.DATE)));*/
        return dateToYearMonthDay(calendar.getTime()) + "," + dateToYearMonthDay(new Date());
    }

    /**
     * @Description: TODO(获得去年)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String lastYear() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(Calendar.YEAR, -1);
        param.append(String.valueOf(calendar.get(Calendar.YEAR)));
        return param.toString();
    }

    /**
     * @Description: TODO(获得上月)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String LastMonth() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(Calendar.MONTH, -1);
        param.append(String.valueOf(calendar.get(Calendar.YEAR))).append("-")
            .append(String.valueOf(calendar.get(Calendar.MONTH) + 1));
        return param.toString();
    }

    /**
     * @Description: TODO(本周 以,隔开)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String thisWeek() {
        Calendar c = Calendar.getInstance();
        int weekday = c.get(7) - 1;
        System.out.println("周天数：" + weekday);
        c.add(5, -weekday);
        String thisWeek = dateToStr(c.getTime());
        System.out.println("本周开始时间：" + dateToStr(c.getTime()));
        c.add(5, 7);
        System.out.println("本周开始结束：" + dateToStr(c.getTime()));
        thisWeek += "," + dateToStr(c.getTime());
        return thisWeek;
    }

    /**
     * @Description: TODO(上周以,隔开)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String lastWeek() {
        /*
         * Calendar calendar = Calendar.getInstance(); int minus=calendar.get(GregorianCalendar.DAY_OF_WEEK)+1;
         * calendar.add(GregorianCalendar.DATE,-minus); String end=new java.sql.Date(calendar.getTime().getTime()).toString();
         * calendar.add(GregorianCalendar.DATE,-4); String begin=new java.sql.Date(calendar.getTime().getTime()).toString();
         */
        String beginTime = getPreviousWeekday();
        String endTime = getPreviousWeekSunday();
        return beginTime + "," + endTime;
    }

    /**
     * @Description: TODO(获得上周星期日的日期)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getPreviousWeekSunday() {
        weeks = 0;
        weeks--;
        int mondayPlus = getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(GregorianCalendar.DATE, mondayPlus + weeks);
        Date monday = currentDate.getTime();
        String preMonday = dateToYearMonthDay(monday);
        return preMonday;
    }

    /**
     * @Description: TODO(获得上周星期一的日期)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getPreviousWeekday() {
        weeks--;
        int mondayPlus = getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(GregorianCalendar.DATE, mondayPlus + 7 * weeks);
        Date monday = currentDate.getTime();
        String preMonday = dateToYearMonthDay(monday);
        return preMonday;
    }

    private static int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        // 获得今天是一周的第几天，星期日是第一天，星期二是第二天......
        int dayOfWeek = cd.get(Calendar.DAY_OF_WEEK) - 1; // 因为按中国礼拜一作为第一天所以这里减1
        if (dayOfWeek == 1) {
            return 0;
        } else {
            return 1 - dayOfWeek;
        }
    }

    /**
     * @Description: TODO(时间加1)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getDateAddOne(String str) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtility.strToDateTime(str));
        calendar.add(Calendar.SECOND, +1);
        String s = dateTimeToStr(calendar.getTime());
        return s;
    }

    /**
     * @Description: TODO(时间减1)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static String getDateSubtractOne(String str) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtility.strToDateTime(str));
        calendar.add(Calendar.SECOND, -1);
        String s = dateTimeToStr(calendar.getTime());
        return s;
    }

    public static Calendar setStartDay(Calendar cal) {
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        return cal;
    }

    public static Calendar setEndDay(Calendar cal) {
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal;
    }

    /**
     * @Description: TODO(把源日历的年月日设置到目标日历对象中)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static void copyYearMonthDay(Calendar destCal, Calendar sourceCal) {
        destCal.set(Calendar.YEAR, sourceCal.get(Calendar.YEAR));
        destCal.set(Calendar.MONTH, sourceCal.get(Calendar.MONTH));
        destCal.set(Calendar.DAY_OF_MONTH, sourceCal.get(Calendar.DAY_OF_MONTH));
    }

    /**
     * @Description: TODO(给定一个日期，返回加减n天后的日期)
     * @Title: getStartQueryTime
     * @author: 许明杰
     * @date: 2013-8-29
     * @param date
     * @return 设定参数
     * @return String 返回类型
     * 
     */
    public static Date nDaysAfterOneDate(Date basicDate, int n) {
        long nDay = (basicDate.getTime() / (24 * 60 * 60 * 1000) + 1 + n) * (24 * 60 * 60 * 1000);
        basicDate.setTime(nDay);

        return basicDate;
    }

}
