package com.northpool.commons.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.google.common.io.Files;
import com.northpool.exception.CommonException;

/**
 * 
 * @ClassName: IOTool
 * @author 张兆阳
 * @date Jan 24, 2013
 * @Description: TODO(IO工具)
 *
 */

public class FileUtil {
    /**
     * 获得目录下所有文件
     * 
     * 
     * 
     */
    public static List<String> getFiles(String dirName) {
        LinkedList<File> list = new LinkedList();
        LinkedList<String> listFileName = new LinkedList();

        File dir = new File(dirName);
        if (!dir.exists()) {
            return new ArrayList();
        }
        File file[] = dir.listFiles();

        for (int i = 0; i < file.length; i++) {

            if (file[i].isDirectory()) {

                list.add(file[i]);

            } else {
                listFileName.add(file[i].getAbsolutePath());
            }
        }

        File tmp;

        while (!list.isEmpty()) {

            tmp = list.removeFirst();

            if (tmp.isDirectory()) {

                file = tmp.listFiles();

                if (file == null) {

                    continue;
                }
                for (int i = 0; i < file.length; i++) {

                    if (file[i].isDirectory()) {

                        list.add(file[i]);

                    } else {

                        listFileName.add(file[i].getAbsolutePath());
                    }
                }

            } else {
                listFileName.add(tmp.getAbsolutePath());

            }

        }
        return listFileName;

    }

    /**
     * 新建目录
     * 
     * @param folderPath
     *            String 如 c:/fqf
     * @return boolean
     */
    public static void newFolder(String folderPath) {
        try {
            String filePath = folderPath;
            filePath = filePath.toString();
            java.io.File myFilePath = new java.io.File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
        } catch (Exception e) {
            //System.out.println("新建目录操作出错");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    
    
    
    /**
     * 新建文件
     * 
     * @param filePathAndName
     *            String 文件路径及名称 如c:/fqf.txt
     * @param fileContent
     *            String 文件内容
     * @return boolean
     */
    public static void newFile(String filePathAndName, String fileContent) {
        FileWriter resultFile = null;
        PrintWriter myFile = null;
        try {
            String filePath = filePathAndName;
            filePath = filePath.toString(); // 取的路径及文件名
            File myFilePath = new File(filePath);
            /** 如果文件不存在就建一个新文件 */
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            resultFile = new FileWriter(myFilePath); // 用来写入字符文件的便捷类, 在给出 File 对象的情况下构造一个 FileWriter 对象
            myFile = new PrintWriter(resultFile); // 向文本输出流打印对象的格式化表示形式,使用指定文件创建不具有自动行刷新的新 PrintWriter。
            String strContent = fileContent;
            myFile.println(strContent);
            

        } catch (Exception e) {
            //System.out.println("新建文件操作出错");
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally{
            try {
                resultFile.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            myFile.close();
        }

    }

    /**
     * 新建文件
     * 
     * @param filePathAndName
     *            String 文件路径及名称 如c:/fqf.txt
     * @param fileContent
     *            String 文件内容
     * @return boolean
     */
    public static boolean createFile(String filePathAndName, String fileContent) {
    	File filePath = new File(filePathAndName);
    	
        /** 如果文件不存在就建一个新文件 */
        if (!filePath.exists()) {
            try {
				filePath.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			}
        }
        try (
        		FileOutputStream outputStream = new FileOutputStream(filePath);
		) {
        	outputStream.write(fileContent.getBytes());
        	outputStream.flush();
        	return true;
        } catch (Exception e) {
        	e.printStackTrace();
		}
        return false;
    }
    
    /**
     * 删除文件
     * 
     * @param filePathAndName
     *            String 文件路径及名称 如c:/fqf.txt
     * @param fileContent
     *            String
     * @return boolean
     */
    public static void delFile(String filePathAndName) {
        try {
            java.nio.file.Path path = Paths.get(filePathAndName);
            java.nio.file.Files.delete(path);

        } catch (NoSuchFileException e) {
        	e.printStackTrace();
        } catch (IOException e) {
			// TODO: handle exception
        	e.printStackTrace();
            throw new RuntimeException(e);
		}

    }

    /**
     * 删除文件夹
     * 
     * @param filePathAndName
     *            String 文件夹路径及名称 如c:/fqf
     * @param fileContent
     *            String
     * @return boolean
     */
    public static void delFolder(String folderPath) {
        try {
            delAllFile(folderPath); // 删除完里面所有内容
            String filePath = folderPath;
            filePath = filePath.toString();
            java.io.File myFilePath = new java.io.File(filePath);
            myFilePath.delete(); // 删除空文件夹

        } catch (Exception e) {
         //   System.out.println("删除文件夹操作出错");
            e.printStackTrace();
            throw new RuntimeException(e);
        }

    }

    /**
     * 删除文件夹里面的所有文件
     * 
     * @param path
     *            String 文件夹路径 如 c:/fqf
     */
    public static void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; i++) {
            if (path.endsWith(File.separator)) {
                temp = new File(path + tempList[i]);
            } else {
                temp = new File(path + File.separator + tempList[i]);
            }
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                delAllFile(path + "/" + tempList[i]);// 先删除文件夹里面的文件
                delFolder(path + "/" + tempList[i]);// 再删除空文件夹
            }
        }
    }

    /**
     * 复制单个文件
     * 
     * @param oldPath
     *            String 原文件路径 如：c:/fqf.txt
     * @param newPath
     *            String 复制后路径 如：f:/fqf.txt
     * @return boolean
     */
    public static void copyFile(String oldPath, String newPath) {
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            // int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) { // 文件存在时
                inStream = new FileInputStream(oldPath); // 读入原文件
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                // int length;
                while ((byteread = inStream.read(buffer)) != -1) {
                    // bytesum += byteread; //字节数 文件大小
                    // System.out.println(bytesum);
                    fs.write(buffer, 0, byteread);
                }
                
            }
        } catch (Exception e) {
          //  System.out.println("复制单个文件操作出错");
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally{
            try {
                inStream.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                fs.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }
    
    public static void copyFolder(String oldPath, String newPath) {
        try {
            copyFolder(oldPath,newPath,true);
        } catch (IOException e) {
            // TODO Auto-generated catch block
           throw new RuntimeException(e);
        }
    }
    
    

    /**
     * 复制整个文件夹内容
     * 
     * @param oldPath
     *            String 原文件路径 如：c:/fqf
     * @param newPath
     *            String 复制后路径 如：f:/fqf/ff
     * @return boolean
     * @throws IOException 
     */
    public static void copyFolder(String oldPath, String newPath,Boolean overwrite) throws IOException {
        FileInputStream input = null;
        FileOutputStream output = null ;
        try {
            (new File(newPath)).mkdirs(); // 如果文件夹不存在 则建立新文件夹
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; i++) {
                if (oldPath.endsWith(File.separator)) {
                    temp = new File(oldPath + file[i]);
                } else {
                    temp = new File(oldPath + File.separator + file[i]);
                }
                if (temp.isFile()) {
                    String newFileName = newPath + File.separator + (temp.getName()).toString();
                    File newFile = new File(newFileName);
                    if(newFile.exists()){
                        if(overwrite){
                            newFile.delete();
                            Files.copy(temp, newFile);
                        }
                    }else{
                        Files.copy(temp, newFile);
                    }
                }
                if (temp.isDirectory()) {// 如果是子文件夹
                    copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i],overwrite);
                }
            }
        } catch (Exception e) {
        //    System.out.println("复制整个文件夹内容操作出错");
            e.printStackTrace();
            throw new IOException(e);
        } finally{
            try {
                if(output != null){
                    output.close();
                }
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                if(input != null){
                    input.close();
                }
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }
    
    public static boolean exists(String path){
        
        File file = new File(path);
        return file.exists();
    }

    /**
     * 复制单个文件
     * 
     * @param oldPath
     *            String 原文件路径 如：c:/fqf.txt
     * @param newPath
     *            String 复制后路径 如：f:/fqf.txt
     * @return boolean
     */
    public static void copyFile(String oldPath, String newPath, Boolean overwrite) {
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            // int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            File newfile = null;
            if (!oldfile.exists()) {
                return;
            }

            if (!overwrite) {
                newfile = new File(newPath);
                if (newfile.exists()) {
                    return;
                }

            }

            // 文件存在时
            inStream = new FileInputStream(oldPath); // 读入原文件
            fs = new FileOutputStream(newPath);
            byte[] buffer = new byte[1444];
            // int length;
            while ((byteread = inStream.read(buffer)) != -1) {
                // bytesum += byteread; //字节数 文件大小
                // System.out.println(bytesum);
                fs.write(buffer, 0, byteread);
            }
            
            fs.flush();
           
            
        } catch (Exception e) {
       //     System.out.println("复制单个文件操作出错");
            e.printStackTrace();
             throw new RuntimeException(e);
        } finally{
            try {
                inStream.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                fs.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }

    /**
     * 移动文件到指定目录
     * 
     * @param oldPath
     *            String 如：c:/fqf.txt
     * @param newPath
     *            String 如：d:/fqf.txt
     */
    public static void moveFile(String oldPath, String newPath) {
        copyFile(oldPath, newPath);
        delFile(oldPath);

    }

    /**
     * 移动文件到指定目录
     * 
     * @param oldPath
     *            String 如：c:/fqf.txt
     * @param newPath
     *            String 如：d:/fqf.txt
     * @throws IOException 
     */
    public static void moveFolder(String oldPath, String newPath) throws IOException {
        copyFolder(oldPath, newPath);
        delFolder(oldPath);

    }

    public static final int BUFSIZE = 1024 * 8;

    /**
     * 合并文件
     * 
     * @param outFile
     * @param files
     */
    public static void mergeFiles(String outFile, String[] files, String extend) {
        FileChannel outChannel = null;
        // out.println("Merge " + Arrays.toString(files) + " into " + outFile);
        try {
            outChannel = new FileOutputStream(outFile, true).getChannel();
            for (String f : files) {
                FileChannel fc = new FileInputStream(f).getChannel();
                ByteBuffer bb = ByteBuffer.allocate(BUFSIZE);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    outChannel.write(bb);
                    bb.clear();
                }
                outChannel.write(ByteBuffer.wrap(extend.getBytes()));
                fc.close();
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            } catch (IOException ignore) {
            }
        }
    }

    public static OutputStream getOutputStream(String path, Boolean getNewOne) throws CommonException, IOException {
        File file = new File(path);
        if (getNewOne) {
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new CommonException("路径" + path + "不是一个有效文件");
                } else {
                    delFile(path);
                }
            } else {
                file.createNewFile();
            }
            return new FileOutputStream(path);
        } else {
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new CommonException("路径" + path + "不是一个有效文件");
                }
            } else {
                file.createNewFile();
            }
            return new FileOutputStream(path);
        }
    }

    public static byte[] File2byte(String filePath) {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        byte[] buffer = null;
        try {

            File file = new File(filePath);
            // file.
            fis  = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int n;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            
            buffer = bos.toByteArray();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally{
            try {
                fis.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                bos.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return buffer;
    }
    
    
    public static void byte2File(byte[] buf, String fileName) {
        
        Path path = Paths.get(fileName);
        byte2File(buf,path.getParent().toString(),path.getFileName().toString());
    }

    public static void byte2File(byte[] buf, String filePath, String fileName) {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] a) throws IOException {
      String f = "C:\\transtest\\create_file_dir\\complete\\测试全量协议action1\\";
       String t = "C:\\transtest\\send_file_dir\\complete\\测试全量协议action1\\";
       FileUtil.copyFolder(f, t);

    }

}
