package com.northpool.commons.util;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;

public class IntBuilder implements RandomAccess, Cloneable, Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final int[] EMPTY_ELEMENTDATA = new int[0];
    private static final int[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new int[0];
    transient int[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 2147483639;
    protected transient int modCount = 0;

    public IntBuilder(int capacity) {
        if (capacity > 0) {
            this.elementData = new int[capacity];
        } else {
            if (capacity != 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + capacity);
            }

            this.elementData = EMPTY_ELEMENTDATA;
        }

    }

    public IntBuilder() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }

    }

    public void ensureCapacity(int size) {
        int var2 = this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA ? 0 : 10;
        if (size > var2) {
            this.ensureExplicitCapacity(size);
        }

    }

    private void ensureCapacityInternal(int size) {
        if (this.elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            size = Math.max(10, size);
        }

        this.ensureExplicitCapacity(size);
    }

    private void ensureExplicitCapacity(int size) {
        ++this.modCount;
        if (size - this.elementData.length > 0) {
            this.grow(size);
        }

    }

    private void grow(int size) {
        int var2 = this.elementData.length;
        int var3 = var2 + (var2 >> 1);
        if (var3 - size < 0) {
            var3 = size;
        }

        if (var3 - 2147483639 > 0) {
            var3 = hugeCapacity(size);
        }

        this.elementData = Arrays.copyOf(this.elementData, var3);
    }

    private static int hugeCapacity(int size) {
        if (size < 0) {
            throw new OutOfMemoryError();
        } else {
            return size > 2147483639 ? 2147483647 : 2147483639;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }



    public int[] toArray() {
        int[] var1 = new int[this.size];
        System.arraycopy(this.elementData, 0, var1, 0, this.size);
        return var1;
    }


    public int get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    public boolean add(int val) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = val;
        return true;
    }

    public boolean addAll(IntBuilder c) {
        int[] a = c.toArray();
        int numNew = a.length;
        ensureCapacityInternal(size + numNew);  // Increments modCount
        System.arraycopy(a, 0, elementData, size, numNew);
        size += numNew;
        return numNew != 0;
    }

    public void add(int index, int val) {
        this.rangeCheckForAdd(index);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = val;
        ++this.size;
    }


    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }


    public static void main(String[] args) {
        System.out.println(null == null);

        long start = System.currentTimeMillis();
        List<Integer> builder = new ArrayList<>(100);
        for (int i = 0; i < 100000000; i++) {
            builder.add(i);
        }
/*        IntBuilder builder = new IntBuilder(100);
        for (int i = 0; i < 100000000; i++) {
            builder.add(i);
        }*/
        long heapSize = Runtime.getRuntime().totalMemory();
        System.out.println(heapSize);
        System.out.println(System.currentTimeMillis() - start);
    }


}
