/**
　 * <p>Title: Tips.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年7月22日
　 * @version 1.0
*/
package com.northpool.commons.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * 
 *
 */
    public class Joys {
    
    public static <R> R tryTimes(Supplier<R> s,int times,int retryDelay) throws Exception{
        int trytimes = 0;
        Exception exception = null;
        while(trytimes < times){
            try{
                R r = s.get();
                return r;
            }catch(Exception e){
                e.printStackTrace();
                exception = e;
                trytimes ++;
            }
            Thread.sleep(retryDelay);
        }
        throw new Exception("超过最大尝试次数,尝试失败" + exception.getMessage());
    }
    
    private static <R> void asyncTry(Supplier<R> s,int time,int maxTimes,int retryDelay,ScheduledExecutorService service,CompletableFuture<R> future){
        
        service.schedule(() -> {
            try{
                R r = s.get();
                future.complete(r);
            }catch(Exception e){
                if(time == maxTimes){
                    future.completeExceptionally(e);
                }else{
                    int timeNext = time + 1;
                    asyncTry(s,timeNext,maxTimes,retryDelay,service,future);
                }
            }
        }, retryDelay, TimeUnit.MILLISECONDS);
            
    }
    
    public static <R> CompletableFuture<R> asyncTryTimes(Supplier<R> s,int times,int retryDelay,ScheduledExecutorService service){
        CompletableFuture<R> future = new CompletableFuture<>();
        try{
            R r = s.get();
            future.complete(r);
        }catch(Exception e){
            int timeNext = 1;
            asyncTry(s,timeNext,times,retryDelay,service,future);
        }
        return future;
    }
    
    public static Integer get() throws Exception{
        System.out.println("do");
        Thread.sleep(1000);
        
        throw new Exception("aaaaaaaaaa");
        
    }
    
    
    public static void main(String[] aaa){
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
       
            CompletableFuture f = asyncTryTimes( ()->{
                
                Integer i = 0;
                try {
                     i = get();
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    throw new RuntimeException(e);
                }
                return i;
            },10,1000,service);
     
        
        try {
            f.get();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        System.out.println("ccccccc");
    }

}
