/**
 * <p>
 * Title: LexerString.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 * 
 *  @date 2021年1月21日 @version 1.0
 */
package com.northpool.commons.util;

/**
 * 
 *
 */
public class LexerString {

    private char[] array;
    private int length;
    private int pos = 0;
    private String token;
    private int savePos = -1;
    
    public void lexer(String input){
        this.array = input.toCharArray();
        this.length = this.array.length;
        this.pos = 0;        
    }
    
    public void save(){
        this.savePos = this.pos;
    }
    
    public void restore(){
        if( this.savePos != -1){
            this.pos = this.savePos;
            this.savePos = -1;
        }
    }
    
    

    public String token() {
        return token;
    }

    public String nextToken(char comma) {
        if (pos < length) {
            StringBuilder out = new StringBuilder(16);
            while (pos < length && array[pos] != comma) {
                out.append(array[pos]);
                pos++;
            }
            pos++;
            token = out.toString();
        } else {
            token = null;
        }

        return token;
    }

    public String nextTokenToQuote() {
        if (pos < length) {
            int commaCount = 1;
            StringBuilder out = new StringBuilder(16);
            while (!((pos == length - 1 || (array[pos + 1] == ' ' && commaCount % 2 == 1)) && array[pos] == '\'')) {
                if (array[pos] == '\'') {
                    commaCount++;
                }
                out.append(array[pos]);
                pos++;
            }
            pos++;
            token = out.toString();
        } else {
            token = null;
        }
        return token;
    }

    public void skip(int skip) {
        this.pos += skip;
    }

    public char current() {
        return array[pos];
    }

    public boolean hasNext() {
        return pos < length;
    }
   
}
