package com.northpool.commons.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import sun.nio.ch.DirectBuffer;

public class StringBuilderL extends AbstractStringBuilder {
	public StringBuilderL() {
		super();
	}

	
	
	public StringBuilderL(String str) {
		super(str);
	}
	@Override
	public ByteOrder order() {
        return ((ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN)
                ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

	@Override
	public void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length) {
		
		if(!(buffer instanceof DirectBuffer)){
			throw new RuntimeException("buffer必须是DirectBuffer");
		}
		// TODO Auto-generated method stub
		 int pos = buffer.position() / this.charSize;
         int lim = buffer.limit() / this.charSize;
         assert (pos <= lim);
         int rem = (pos <= lim ? lim - pos : 0);
         if (length > rem){
             throw new BufferOverflowException();
         }
         
         DirectBuffer directBuffer = (DirectBuffer)buffer;
         
         long dstAddr = directBuffer.address() + ((long)pos  << 1);
         try{
	         if (order() != ByteOrder.nativeOrder()){
	        	 UnsafeFuntion.get().copyFromCharArray(arr, (long)offset << 1, dstAddr,  (long)length << 1);
	         }else{
	        	 UnsafeFuntion.get().copyFromArray(arr, UnsafeFuntion.charArrayOffset,(long)offset << 1, dstAddr,  (long)length << 1); 
	         }
         }catch(Exception e){
        	 throw new RuntimeException(e);
         }
         buffer.position((pos + length) * this.charSize);
	}



	
}
