package com.northpool.commons.util;

import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;

import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

import com.northpool.exception.CommonException;


/**
 * @Description： TODO
 * @ClassName：StringUtility
 * @author： 许明杰
 * @date： 2011-7-4
 * 
 */

public class StringUtility {
	/**
	 * Private constructor to prevent instantiation.
	 * 
	 */
	private StringUtility() {
	}

	// Constants used by escapeHTMLTags " 引号
	private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();

	// &符号 
	private static final char[] AMP_ENCODE = "&amp;".toCharArray();

	// < 小于号
	private static final char[] LT_ENCODE = "&lt;".toCharArray();

	// > 大于号
	private static final char[] GT_ENCODE = "&gt;".toCharArray();
	// Constants that the SqlServer sql string not support
	private static HashMap sqlTokens = new HashMap();
	static {

		sqlTokens.put("'", "''");

	}

	public static String getDataSize(long size){  
        DecimalFormat formater = new DecimalFormat("####.00");  
        if(size<1024){  
            return size+"bytes";  
        }else if(size<1024*1024){  
            float kbsize = size/1024f;    
            return formater.format(kbsize)+"KB";  
        }else if(size<1024*1024*1024){  
            float mbsize = size/1024f/1024f;    
            return formater.format(mbsize)+"MB";  
        }else {  
            float gbsize = size/1024f/1024f/1024f;    
            return formater.format(gbsize)+"GB";  
        }
	}
	
	/**
	 * Replace the sqlserver takens with the right characters.
	 * 
	 * @param oldString
	 * @return
	 */
	public static double DoubleValue(String str) {
		if (str != null && !str.equalsIgnoreCase("-")) {
			if (str.indexOf('%') > 0) {
				str = str.replaceAll("%", "");
			}
			return Double.parseDouble(str.trim());
		} else {
			return 0;
		}
	}

	/**
	 * @Description: 编译sql字符串
	 * @Title: encodeSql
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param oldString
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static final String encodeSql(String oldString) {
		if (oldString == null) {
			return null;
		}
		Set tokensSet = sqlTokens.entrySet();

		for (Iterator it = tokensSet.iterator(); it.hasNext();) {
			java.util.Map.Entry entry = (java.util.Map.Entry) it.next();
			oldString = replace(oldString, (String) entry.getKey(), (String) entry.getValue());
		}

		return oldString;

	}

	/**
	 * Replaces all instances of oldString with newString in line.
	 * 
	 * @param line
	 *            the String to search to perform replacements on
	 * @param oldString
	 *            the String that should be replaced by newString
	 * @param newString
	 *            the String that will replace all instances of oldString
	 * 
	 * @return a String will all instances of oldString replaced by newString
	 */
	public static final String replace(String line, String oldString, String newString) {
		if (line == null) {
			return null;
		}
		int i = 0;
		if ((i = line.indexOf(oldString, i)) >= 0) {
			char[] line2 = line.toCharArray();
			char[] newString2 = newString.toCharArray();
			int oLength = oldString.length();
			StringBuffer buf = new StringBuffer(line2.length);
			buf.append(line2, 0, i).append(newString2);
			i += oLength;
			int j = i;
			while ((i = line.indexOf(oldString, i)) > 0) {
				buf.append(line2, j, i - j).append(newString2);
				i += oLength;
				j = i;
			}
			buf.append(line2, j, line2.length - j);
			return buf.toString();
		}
		return line;
	}

	/**
	 * Replaces all instances of oldString with newString in line with the added feature that matches of newString in oldString
	 * ignore case.
	 * 
	 * @param line
	 *            the String to search to perform replacements on
	 * @param oldString
	 *            the String that should be replaced by newString
	 * @param newString
	 *            the String that will replace all instances of oldString
	 * 
	 * @return a String will all instances of oldString replaced by newString
	 */
	public static final String replaceIgnoreCase(String line, String oldString, String newString) {
		if (line == null) {
			return null;
		}
		String lcLine = line.toLowerCase();
		String lcOldString = oldString.toLowerCase();
		int i = 0;
		if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
			char[] line2 = line.toCharArray();
			char[] newString2 = newString.toCharArray();
			int oLength = oldString.length();
			StringBuffer buf = new StringBuffer(line2.length);
			buf.append(line2, 0, i).append(newString2);
			i += oLength;
			int j = i;
			while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
				buf.append(line2, j, i - j).append(newString2);
				i += oLength;
				j = i;
			}
			buf.append(line2, j, line2.length - j);
			return buf.toString();
		}
		return line;
	}

	/**
	 * Replaces all instances of oldString with newString in line with the added feature that matches of newString in oldString
	 * ignore case. The count paramater is set to the number of replaces performed.
	 * 
	 * @param line
	 *            the String to search to perform replacements on
	 * @param oldString
	 *            the String that should be replaced by newString
	 * @param newString
	 *            the String that will replace all instances of oldString
	 * @param count
	 *            a value that will be updated with the number of replaces performed.
	 * 
	 * @return a String will all instances of oldString replaced by newString
	 */
	public static final String replaceIgnoreCase(String line, String oldString, String newString, int[] count) {
		if (line == null) {
			return null;
		}
		String lcLine = line.toLowerCase();
		String lcOldString = oldString.toLowerCase();
		int i = 0;
		if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
			int counter = 0;
			char[] line2 = line.toCharArray();
			char[] newString2 = newString.toCharArray();
			int oLength = oldString.length();
			StringBuffer buf = new StringBuffer(line2.length);
			buf.append(line2, 0, i).append(newString2);
			i += oLength;
			int j = i;
			while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
				counter++;
				buf.append(line2, j, i - j).append(newString2);
				i += oLength;
				j = i;
			}
			buf.append(line2, j, line2.length - j);
			count[0] = counter;
			return buf.toString();
		}
		return line;
	}

	/**
	 * Replaces all instances of oldString with newString in line. The count Integer is updated with number of replaces.
	 * 
	 * @param line
	 *            the String to search to perform replacements on
	 * @param oldString
	 *            the String that should be replaced by newString
	 * @param newString
	 *            the String that will replace all instances of oldString
	 * 
	 * @return a String will all instances of oldString replaced by newString
	 */
	public static final String replace(String line, String oldString, String newString, int[] count) {
		if (line == null) {
			return null;
		}
		int i = 0;
		if ((i = line.indexOf(oldString, i)) >= 0) {
			int counter = 0;
			counter++;
			char[] line2 = line.toCharArray();
			char[] newString2 = newString.toCharArray();
			int oLength = oldString.length();
			StringBuffer buf = new StringBuffer(line2.length);
			buf.append(line2, 0, i).append(newString2);
			i += oLength;
			int j = i;
			while ((i = line.indexOf(oldString, i)) > 0) {
				counter++;
				buf.append(line2, j, i - j).append(newString2);
				i += oLength;
				j = i;
			}
			buf.append(line2, j, line2.length - j);
			count[0] = counter;
			return buf.toString();
		}
		return line;
	}

	/**
	 * This method takes a string which may contain HTML tags (ie, &lt;b&gt;, &lt;table&gt;, etc) and converts the '&lt'' and
	 * '&gt;' characters to their HTML escape sequences.
	 * 
	 * @param in
	 *            the text to be converted.
	 * @return the input string with the characters '&lt;' and '&gt;' replaced with their HTML escape sequences.
	 */
	public static final String escapeHTMLTags(String in) {
		if (in == null) {
			return null;
		}
		char ch;
		int i = 0;
		int last = 0;
		char[] input = in.toCharArray();
		int len = input.length;
		StringBuffer out = new StringBuffer((int) (len * 1.3));
		for (; i < len; i++) {
			ch = input[i];
			if (ch > '>') {
				continue;
			} else if (ch == '<') {
				if (i > last) {
					out.append(input, last, i - last);
				}
				last = i + 1;
				out.append(LT_ENCODE);
			} else if (ch == '>') {
				if (i > last) {
					out.append(input, last, i - last);
				}
				last = i + 1;
				out.append(GT_ENCODE);
			}
		}
		if (last == 0) {
			return in;
		}
		if (i > last) {
			out.append(input, last, i - last);
		}
		return out.toString();
	}

	/**
	 * Turns an array of bytes into a String representing each byte as an unsigned hex number.
	 * <p>
	 * Method by Santeri Paavolainen, Helsinki Finland 1996<br>
	 * (c) Santeri Paavolainen, Helsinki Finland 1996<br>
	 * Distributed under LGPL.
	 * 
	 * @param bytes
	 *            an array of bytes to convert to a hex-string
	 * @return generated hex string
	 */
	public static final String encodeHex(byte[] bytes) {
		StringBuffer buf = new StringBuffer(bytes.length * 2);
		int i;

		for (i = 0; i < bytes.length; i++) {
			if (((int) bytes[i] & 0xff) < 0x10) {
				buf.append("0");
			}
			buf.append(Long.toString((int) bytes[i] & 0xff, 16));
		}
		return buf.toString();
	}

	/**
	 * Turns a hex encoded string into a byte array. It is specifically meant to "reverse" the toHex(byte[]) method.
	 * 
	 * @param hex
	 *            a hex encoded String to transform into a byte array.
	 * @return a byte array representing the hex String[
	 */
	public static final byte[] decodeHex(String hex) {
		char[] chars = hex.toCharArray();
		byte[] bytes = new byte[chars.length / 2];
		int byteCount = 0;
		for (int i = 0; i < chars.length; i += 2) {
			byte newByte = 0x00;
			newByte |= hexCharToByte(chars[i]);
			newByte <<= 4;
			newByte |= hexCharToByte(chars[i + 1]);
			bytes[byteCount] = newByte;
			byteCount++;
		}
		return bytes;
	}

	/**
	 * @Description: TODO 过滤为null的字符串，如果为空返回
	 * @Title: filterNull
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String filterNull(String str) {
		if (str == null) {
			return new String("");
		} else {
			return str;
		}
	}
	
	/**
	 * @Description: TODO 过滤为htmlNull的字符串，如果为空返回&nbsp;
	 * @Title: filterNull
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String htmlNull(String str) {
		if (str == null || str.equals("")) {
			return new String("&nbsp;");
		} else {
			return str;
		}
	}

	/**
	 * 
	 * @Description: TODO(过滤整数，如果为空返回&nbsp;)
	 * @Title: htmlNull
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param i
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String htmlNull(Integer i) {
		if (i == null) {
			return new String("&nbsp;");
		} else {
			return i.toString();
		}
	}

	/**
	 * Returns the the byte value of a hexadecmical char (0-f). It's assumed that the hexidecimal chars are lower case as
	 * appropriate.
	 * 
	 * @param ch
	 *            a hexedicmal character (0-f)
	 * @return the byte value of the character (0x00-0x0F)
	 */
	private static final byte hexCharToByte(char ch) {
		switch (ch) {
		case '0':
			return 0x00;
		case '1':
			return 0x01;
		case '2':
			return 0x02;
		case '3':
			return 0x03;
		case '4':
			return 0x04;
		case '5':
			return 0x05;
		case '6':
			return 0x06;
		case '7':
			return 0x07;
		case '8':
			return 0x08;
		case '9':
			return 0x09;
		case 'a':
			return 0x0A;
		case 'b':
			return 0x0B;
		case 'c':
			return 0x0C;
		case 'd':
			return 0x0D;
		case 'e':
			return 0x0E;
		case 'f':
			return 0x0F;
		}
		return 0x00;
	}

	 /**
	  * @Description: TODO(类似JavaScript中的escape()转码方法)
	  * @Title: escape
	  * @author: 许明杰
	  * @date: 2013-8-29
	  * @param src
	  * @return   设定参数 
	  * @return String    返回类型
	  * 
	  */
	public static String escape(String src) {
		int i;
		char j;
		StringBuffer tmp = new StringBuffer();
		tmp.ensureCapacity(src.length() * 6);

		for (i = 0; i < src.length(); i++) {
			j = src.charAt(i);
			if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)){
				tmp.append(j);
			}else if (j < 256) {
				tmp.append("%");
				if (j < 16){
					tmp.append("0");
				}
				tmp.append(Integer.toString(j, 16));
			} else {
				tmp.append("%u");
				tmp.append(Integer.toString(j, 16));
			}
		}
		return tmp.toString();
	}

	/**
	 * @Description: TODO(类似JavaScript中的unescape() 转码方法)
	 * @Title: unescape
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param src
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String unescape(String src) {
		if (src == null) {
			return null;
		}

		StringBuffer tmp = new StringBuffer();
		tmp.ensureCapacity(src.length());
		int lastPos = 0, pos = 0;
		char ch;
		while (lastPos < src.length()) {
			pos = src.indexOf("%", lastPos);
			if (pos == lastPos) {
				if (src.charAt(pos + 1) == 'u') {
					ch = (char) Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
					tmp.append(ch);
					lastPos = pos + 6;
				} else {
					ch = (char) Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
					tmp.append(ch);
					lastPos = pos + 3;
				}
			} else {
				if (pos == -1) {
					tmp.append(src.substring(lastPos));
					lastPos = src.length();
				} else {
					tmp.append(src.substring(lastPos, pos));
					lastPos = pos;
				}
			}
		}
		return tmp.toString();
	}

	/**
	 * @Description: TODO(截取字符串)
	 * @Title: substring
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @param start
	 * @param end
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String substring(String str, int start, int end) {
		if (str == null) {
			return null;
		}

		// handle negatives
		if (end < 0) {
			end = str.length() + end; // remember end is negative
		}
		if (start < 0) {
			start = str.length() + start; // remember start is negative
		}

		// check length next
		if (end > str.length()) {
			end = str.length();
		}

		// if start is greater than end, return ""
		if (start > end) {
			return "";
		}

		if (start < 0) {
			start = 0;
		}
		if (end < 0) {
			end = 0;
		}

		return str.substring(start, end);
	}

	/**
	 * @Description: TODO(日期为201304转换为2013年04月)
	 * @Title: formatYearMonth
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param _yearMonth
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatYearMonth(String _yearMonth) {
		return _yearMonth.substring(0, 4) + "年" + _yearMonth.substring(4) + "月";

	}

	/**
	 * @Description: TODO(判断字符串是否为空)
	 * @Title: isNullOrBlank
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return boolean    返回类型
	 * 
	 */
	public static boolean isNullOrBlank(String str) {
		return (str == null || str.trim().length() == 0);

	}

	/**
	 * @Description: TODO(如果对象为null，则返回“&nbsp;”)
	 * @Title: null2Str
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param objIn
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String null2Str(Object objIn) {
		return (objIn == null) ? "&nbsp;" : String.valueOf(objIn);
	}

	/**
	 *  @Description: TODO(如果str为空，则返回str。如果str不为空，则返回re的值)
	 * @Title: nvl
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @param re
	 * @return   设定参数 
	 * @return String    返回类型
	 *
	 */
	public static String nvl(String str, String re) {
		if (str != null && !str.equals("")) {
			return str;
		} else {
			return re;
		}
	}

	/**
	 * 
	 * @Description: TODO(格式化id)
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param id
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String formatBillNo(String id) {
		Integer iPk = Integer.valueOf(id);
		int cont = 100000000;
		int temp = cont + iPk.intValue();
		String iStr = String.valueOf(temp);
		iStr = iStr.substring(1);

		return "N" + iStr;
	}

	/**
	 * @Description: TODO(字符串转换成UTF)
	 * @Title: toUTF
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param src
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String toUTF(String src) {
		byte[] tmp = new byte[src.length() >> 1];
		for (int i = 0; i < tmp.length; i++) {
			// System.out.println(i*2+","+i*+2);
			tmp[i] = (byte) Integer.parseInt(src.substring(i * 2, i * 2 + 2), 16);

		}
		try {
			return new String(tmp, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			return "";
		}

	}

	/**
	 * @Description: TODO(把单词的首字母变为大写，其余的字母小写)
	 * @Title: initialUpper
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String initialUpper(String str) {
		StringBuffer sb = new StringBuffer();
		char[] words = str.toCharArray();
		char prevc = ' ';
		for (char c : words) {
			if (c != ' ' && prevc == ' ') {
				sb.append(Character.toUpperCase(c));
			} else {
				sb.append(Character.toLowerCase(c));
			}
			prevc = c;
		}

		return sb.toString();
	}

	/**
	 * @Description: TODO(A010203001字符串转换为A\A01\A0102\A010203\A010203001形式的路径)
	 * @Title: pathString
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String pathString(String str) {
		StringBuffer strBuf = new StringBuffer();
		int temp = 0;
		strBuf.append(str.substring(0, 1));
		for (int i = 1; i < str.length(); i++) {
			temp++;
			strBuf.append("\\");
			if (i == str.length()) {
				strBuf.append(str.substring(0, str.length()));
			} else {
				if (temp == 4) {
					strBuf.append(str.substring(0, i + 3));
					i++;
				} else {
					strBuf.append(str.substring(0, i + 2));
				}
			}
			i++;
		}
		return strBuf.toString();
	}

	/**
	 * @Description: TODO(A010203001字符串转换为A,A01,A0102,A010203,A010203001形式的路径)
	 * @Title: splitPathString
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String splitPathString(String str) {
		StringBuffer strBuf = new StringBuffer();
		int temp = 0;
		strBuf.append(str.substring(0, 1));
		for (int i = 1; i < str.length(); i++) {
			temp++;
			strBuf.append(",");
			if (i == str.length()) {
				strBuf.append(str.substring(0, str.length()));
			} else {
				if (temp == 4) {
					strBuf.append(str.substring(0, i + 3));
					i++;
				} else {
					strBuf.append(str.substring(0, i + 2));
				}
			}
			i++;
		}
		return strBuf.toString();
	}

	/**
	 * @Description: TODO(获得一个字符串中某个字符出现的次数)
	 * @Title: numberOfStr
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param str
	 * @param subStr
	 * @return   设定参数 
	 * @return int    返回类型
	 * 
	 */
	public static int numberOfStr(String str, String subStr) {
		if (str.endsWith(subStr)) {
			return str.split(subStr).length;
		} else {
			return str.split(subStr).length - 1;
		}
	}

	/**
	 * @Description: TODO(获取32位随机串)
	 * @Title: getUUID
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String getUUID() {
		String uuid = UUID.randomUUID().toString().replaceAll("-", "");
		return uuid;
	}

	/**
	 * 
	 * @Title: delBlank
	 * @author: 许明杰
	 * @date: 2011-4-11
	 * @param @param str
	 * @param @return 设定文件
	 * @return String 返回类型
	 * @Description: Java去除字符串中的空格、回车、换行符、制表符
	 * @throws
	 */
	public static Pattern p_n = Pattern.compile("\n");;
	
	public static String delBlank(String str) {
		// Java去除字符串中的空格、回车、换行符、制表符 Pattern p = Pattern.compile("\\s*|\t|\r|\n");
	//	Pattern p = 
		Matcher m = p_n.matcher(str);
		String after = m.replaceAll("");
		return after;
	}
	
	/**
	 * 
	 * @Title: equals
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param a1
	 * @param a2
	 * @return   设定参数 
	 * @return Boolean    返回类型
	 * @Description: 判断两个字符串是否相等
	 */
	public static Boolean equals(String a1,String a2){
		if(a1 == null && a2 == null){
			return true;
		}
		if(a1 != null){
			return a1.equals(a2);
		}
		if(a2 != null){
			return a2.equals(a1);
		}
		return false;
	}
	/**
	 * 
	 * @Title: equalsIgnoreCase
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param a1
	 * @param a2
	 * @return   设定参数 
	 * @return Boolean    返回类型
	 * @Description: TODO equalsIgnoreCase
	 */
	public static Boolean equalsIgnoreCase(String a1,String a2){
		if(a1 == null && a2 == null){
			return true;
		}
		if(a1 != null){
			return a1.equalsIgnoreCase(a2);
		}
		if(a2 != null){
			return a2.equalsIgnoreCase(a1);
		}
		return false;
	}
	
	/**
	 * 
	 * @Title: indexOf
	 * @author: 张兆阳
	 * @date: Feb 5, 2013
	 * @param a1
	 * @param a2
	 * @return   设定参数 
	 * @return Integer    返回类型
	 * @Description: TODO(这里用一句话描述这个方法的作用)
	 */
	public static Integer indexOf(String a1,String a2){
		if(a1 == null || a2 == null){
			return null;
		}
		return a1.indexOf(a2);
	}
	
	
	/**
	 * @Description: TODO(判断字符串是否是函数)
	 * @Title: isFunction
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param s
	 * @return   设定参数 
	 * @return Boolean    返回类型
	 * 
	 */
	public static Pattern p_function = Pattern.compile("\\(([^\\(]+)\\)");
	
	public static Boolean isFunction(String s){
		Matcher matcher = p_function.matcher(s);
		return matcher.find();
	}
	
	
	
	/**
	 * @Description: TODO(获取函数信息)
	 * @Title: getFunctionInfo
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param s
	 * @return   设定参数 
	 * @return String[]    返回类型
	 *
	 */
	public static String[] getFunctionInfo(String s){
		StringBuffer sb = new StringBuffer(s);
		int index = 0;
		int cutBeginIndex = -1;
		int cutEndIndex = -1;
		while(index < sb.length()){
			char mark = sb.charAt(index);
			if(mark == '('){
				cutBeginIndex = index;
				break;
			}
			index ++;
		}
		if(cutBeginIndex == -1){
			return null;
		}
		index = sb.length() - 1;
		while(index > 0){
			char mark = sb.charAt(index);
			if(mark == ')'){
				cutEndIndex = index;
				break;
			}
			index --;
		}
		String[] info = new String[2];
		String functionName = s.substring(0,cutBeginIndex).trim();
		String parms = s.substring(cutBeginIndex + 1,cutEndIndex);
		info[0] = functionName;
		info[1] = parms;
		return info;
	}
	
	
	

	
	/**
	 * @Description: TODO(将java.sql.Clob转成String)
	 * @Title: clobToString
	 * @author: 许明杰
	 * @date: 2013-8-29
	 * @param clob
	 * @return   设定参数 
	 * @return String    返回类型
	 * 
	 */
	public static String clobToString(Clob clob) {
		if (clob == null) {
			return null;
		}
		StringBuffer sb = new StringBuffer();
		Reader clobStream = null;
		try {
			clobStream = clob.getCharacterStream();
			char[] b = new char[60000];// 每次获取60K
			int i = 0;
			while ((i = clobStream.read(b)) != -1) {
				sb.append(b, 0, i);
			}
		} catch (Exception ex) {
			sb = null;
		} finally {
			try {
				if (clobStream != null) {
					clobStream.close();
				}
			} catch (Exception e) {
			}
		}
		if (sb == null) {
			return null;
		}else{
			return sb.toString();
		}
	}
	/**
	 * String 转 clob
	 * @param str
	 * @return
	 * @throws SerialException
	 * @throws SQLException
	 */
	public static Clob stringToClob(String str) throws SerialException, SQLException {
		Clob c = new SerialClob(str.toCharArray());
		return c;
	}
	
	
	public static Geometry stringToGeometry(String value){
		WKTReader fromText = new WKTReader();
	    Geometry geometry = null;
	    try{
	    	geometry = fromText.read(value);
	    } catch(ParseException e){
	        //throw new RuntimeException("Not a WKT String:" + value);
	    	return null;
	    }
	    return geometry;
	}
	
	
	public static String changeHtm(String changeHtmlValue){
		StringBuffer sb = new StringBuffer(changeHtmlValue);
		char[] code = changeHtmlValue.toCharArray();
		int length = sb.length();
		char[] newcode = new char[length * 5];
		int index = 0;
		int codeIndex = 0;
		int newcodeIndex = 0;
		int copyLenght = 0;
		while(index < length){
			char indexChar = sb.charAt(index);
			char[][] replacement = getReplacement(code, index);
			if(replacement != null){//39'34"92\
				//判断前面一位是否是\\
				char[] ori = replacement[0];
				int oriLength = ori.length;
				char[] target = replacement[1];
				int targetLength = target.length;
				char previous = sb.charAt(index - 1);
				if(previous != 92 || oriLength > 1){
					if(copyLenght != 0){
						System.arraycopy(code, codeIndex, newcode, newcodeIndex, copyLenght);
						newcodeIndex = newcodeIndex + copyLenght;
						codeIndex = codeIndex + copyLenght;
					}
					System.arraycopy(target, 0, newcode, newcodeIndex, targetLength);
					codeIndex = codeIndex + oriLength;
					newcodeIndex = newcodeIndex + targetLength;
					index = index + oriLength;
					copyLenght = 0;
				}
			}else {
				copyLenght ++;
                index ++;
            }
		}
		if(codeIndex == 0){
			return changeHtmlValue;
		}else{
		    if (copyLenght != 0){
                System.arraycopy(code, codeIndex, newcode, newcodeIndex, copyLenght);
                newcodeIndex = newcodeIndex + copyLenght;
            }

			char[] returnCode = new char[newcodeIndex];
			System.arraycopy(newcode, 0, returnCode, 0, newcodeIndex);
			return String.valueOf(returnCode);
		}
	}
	
	public static boolean isNotEmpty(String string) {
		return string != null && string.length() > 0;
	}

	private static char[][] getReplacement(char[] code, int index){
		char[][] symbol = new char[][]{
				{'\r'},{'<','b','r','/','>'},
				{'\n'},{'<','b','r','/','>'},
				{'\t'},{' '},
				{'"'},{'\\','\\','\\','"'},
				{'\\'},{'\\','\\','\\','\\'}
		};
		char[] ori = null;
		char[] target = null;
		int deep = -1;
		int length = 0;
		int codeIndex= 0;

		for (int i = 0; i < symbol.length; i = i+2) {
			codeIndex = index;
			deep = -1;
			ori = symbol[i];
			target = symbol[i + 1];
			length = ori.length;
			while (deep + 1 < length && code[codeIndex] == ori[deep+1]){
				codeIndex++;
				deep++;
			}
			if (deep == length - 1){
				return new char[][]{symbol[i],symbol[i+1]};
			}

		}
		return null;
	}
	
	public  static void main(String[] aaa){
		System.out.print(getFunctionInfo("objectid"));
	}
	
}
