/**
　 * <p>Title: FileMD5.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年9月8日
　 * @version 1.0
*/
package com.northpool.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.northpool.commons.bits.HexUtils;


/**
 * 
 *
 */
public class ThreadLocalMD5 {
    private MessageDigest messagedigest = null;
    
    
    
    
    
    public ThreadLocalMD5(){
        try {
            this.messagedigest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException nsaex) {
            System.err.println(MD5.class.getName()
                    + "初始化失败");
            nsaex.printStackTrace();
        }
    }
    
    public void put(byte[] bytes){
        this.messagedigest.update(bytes);
    }
    
    public void put(byte[] bytes,int offset, int length){
        this.messagedigest.update(bytes,offset,length);
    }
    
    public void reset(){
        this.messagedigest.reset();
    }
    
    public void setFile(File file) throws IOException{
      
        @SuppressWarnings("resource")
        FileChannel ch = new FileInputStream(file).getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0,
                file.length());
        ch.close();
        this.messagedigest.update(byteBuffer);
    }
    
    
    public void setBigFile(File file) throws IOException{
        
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[64 * 1024];
        int len = 0;
        while ((len = fis.read(buffer)) != -1) {
            this.messagedigest.update(buffer, 0, len);
        }
        fis.close();
    }
   
    public String getMD5(){
       
        String md5 = HexUtils.bytesToHexString(this.messagedigest.digest());
        this.messagedigest.reset();
        return md5;
    }
    
    
    
}
