package com.northpool.commons.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;

import com.northpool.commons.reflect.Bean;

import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeFuntion {
	public static Unsafe unsafe = null;
	private static UnsafeFuntion _UnsafeFuntion = new UnsafeFuntion();
	public static UnsafeFuntion get(){
		return _UnsafeFuntion;
	}
	static {
		try {
			Field field = Unsafe.class.getDeclaredField("theUnsafe");
			field.setAccessible(true);
			unsafe = (Unsafe) field.get(null);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public static final long byteArrayOffset = unsafe.arrayBaseOffset(byte[].class);
	public static final long longArrayOffset = unsafe.arrayBaseOffset(long[].class);
	public static final long doubleArrayOffset = unsafe.arrayBaseOffset(double[].class);
	public static final long charArrayOffset = unsafe.arrayBaseOffset(char[].class);
	public static final long StringCharArrayOffset;
	static{
		Field valueInString = null;
		try {
			valueInString = String.class.getDeclaredField("value");
		} catch (NoSuchFieldException | SecurityException e) {
			// TODO Auto-generated catch block
			System.out.println("JVM错误,没有在String中找到字段vlaue[]");
			e.printStackTrace();
		}
		StringCharArrayOffset = unsafe.objectFieldOffset(valueInString);
	}
	
	private HashMap <String,Method> methodMap = new HashMap();
	
	public UnsafeFuntion(){
		try {
			this.copyFromLongArrayMethod();
			this.copyFromArrayMethod();
			this.copyFromCharArrayMethod();
			this.copyToArrayMethod();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public static long objectFieldOffset(Field field){
	    return unsafe.objectFieldOffset(field);
	}
	
	public static boolean compareAndSwapInt(Object o,long inputStateOffset, int c,int nextc){
        return unsafe.compareAndSwapInt(o, inputStateOffset, c, nextc);
    }
	
	
	
	private void copyFromLongArrayMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException{
		Method method = Class.forName("java.nio.Bits").getDeclaredMethod("copyFromLongArray", Object.class,long.class,long.class,long.class);
		method.setAccessible(true);
		methodMap.put("copyFromLongArray", method);
	}
	
	private void copyFromArrayMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException{
		Method method = Class.forName("java.nio.Bits").getDeclaredMethod("copyFromArray", Object.class,long.class,long.class,long.class,long.class);
		method.setAccessible(true);
		methodMap.put("copyFromArray", method);
	}
	
	private void copyFromCharArrayMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException{
		Method method = Class.forName("java.nio.Bits").getDeclaredMethod("copyFromCharArray", Object.class,long.class,long.class,long.class);
		method.setAccessible(true);
		methodMap.put("copyFromCharArray", method);
	}
	
	private void copyToArrayMethod() throws NoSuchMethodException, SecurityException, ClassNotFoundException{
		

		Method method = Class.forName("java.nio.Bits").getDeclaredMethod("copyToArray", long.class,Object.class,long.class,long.class,long.class);
		method.setAccessible(true);
		methodMap.put("copyToArray", method);
	}
	
	
	
	
	
	public void copyFromLongArray(Object src, long srcPos, long dstAddr,
            long length) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
		methodMap.get("copyFromLongArray").invoke(null, src,
				srcPos,
				dstAddr,
				length);
	}
	
	public void copyFromCharArray(Object src, long srcPos, long dstAddr,
            long length) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
		methodMap.get("copyFromCharArray").invoke(null, src,
				srcPos,
				dstAddr,
				length);
	}
	
	
	
	
	public void copyFromArray(Object src, long srcBaseOffset, long srcPos,
            long dstAddr, long length) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
		methodMap.get("copyFromArray").invoke(null, src,srcBaseOffset,
				srcPos,
				dstAddr,
				length);
	}
	
	public void copyToArray(long srcAddr, Object dst, long dstBaseOffset, long dstPos,
            long length) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
		methodMap.get("copyToArray").invoke(null, srcAddr,  dst,  dstBaseOffset,  dstPos, length);
	}
	
	
	
	
	public Object string2char(String str){
		return unsafe.getObject(str, StringCharArrayOffset);
	}
	
	public <T> T createInstance(Class<T> clazz) {
	    try {
	        return (T)unsafe.allocateInstance(clazz);
	    } catch (Exception e) {
	        throw new RuntimeException("cannot instantiate " + clazz + " bypassing default constructor");
	    }
	}
	
	
	public void setMemory(long offset, long bytes, byte value ){
		long offset1 = unsafe.getAddress(offset);
		unsafe.setMemory(offset, bytes, value);
	}
	
	public void copyMemory(Object arg0, long arg1, Object arg2, long arg3, long arg4){
		unsafe.copyMemory(arg0, arg1, arg2, arg3, arg4);
	}
	 
	public void freeDirectBuffer(DirectBuffer directBuffer){
		long address = (long)Bean.getObjectValueByFieldName(directBuffer, "address");
		directBuffer = null;
		//System.gc();
		unsafe.freeMemory(address);
	}
	
	
	public void free(long offset){
		unsafe.freeMemory(offset);
	}
	
	
	
	/*public void copyToLongArray(long srcAddr, Object dst, long dstPos,
          long length){
		
	}*/

}
